% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/akaike_weights.R
\name{akaike_weights}
\alias{akaike_weights}
\title{Akaike weights}
\usage{
akaike_weights(object)
}
\arguments{
\item{object}{a numerical vector with models goodness of fit coefficients}
}
\value{
A data frame containing the coefficients:
\item{delta}{the delta overall change in the coefficients}
\item{relative_logLik}{the relative log-likelihood}
\item{akaike_weights}{the Akaike weights}
}
\description{
Akaike weights represent the relative likelihood of a model.  
It can be used in model averaging and selection.
}
\examples{
 
data("airquality")

# try three model approaches
mod1 = glm(Temp ~ 1,
            data = airquality,
            family = poisson())

mod2 = glm(Temp ~ Ozone,
            data = airquality,
            family = poisson())

mod3 = glm(Temp ~ Ozone + Solar.R,
            data = airquality,
            family = poisson())

# models AICs together in a single vector
models = c(mod1 = AIC(mod1),
            mod2 = AIC(mod2),
            mod3 = AIC(mod3))

# calculate akaike weights
aw = akaike_weights(models)

# the higher the better
names(models[which.max(aw$akaike_weights)])

}
\references{
Wagenmakers E. J. & Farrell S. (2004). 
Psychonomic Bulletin and Review, 11(1), 192–196. 
\doi{https://doi.org/10.3758/BF03206482}
}
\author{
Kauê de Sousa and Jacob van Etten
}
