% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwe.R
\name{pwe_sim}
\alias{pwe_sim}
\title{Simulate piecewise exponential time-to-event outcomes}
\usage{
pwe_sim(n = 1, hazard = 1, cutpoints = 0, maxtime = NULL)
}
\arguments{
\item{n}{integer. The number of random samples to generate. Default is
\code{n=1}.}

\item{hazard}{vector. The constant hazard rates for exponential failures.}

\item{cutpoints}{vector. The change-point vector indicating time when the
hazard rates change. Note the first element of \code{cutpoints} should
always be 0.}

\item{maxtime}{scalar. Maximum time before end of study.}
}
\value{
A data frame with simulated follow-up times (\code{time}) and
respective event indicator (\code{event}, 1 = event occurred, 0 =
censoring).
}
\description{
Simulate time-to-event outcomes using the piecewise constant
hazard exponential function.
}
\details{
See \code{\link{pwe_impute}} for details.
}
\examples{
pwe_sim(10, hazard = c(0.005, 0.001), cutpoints = c(0, 3), maxtime = 36)
y <- pwe_sim(n = 1, hazard = c(2.585924e-02, 3.685254e-09),
             cutpoints = c(0, 12))
}
