% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterReforms.R
\name{get_unconstrained_structural_pars}
\alias{get_unconstrained_structural_pars}
\title{Get structural parameters that indicate there are no constraints}
\usage{
get_unconstrained_structural_pars(structural_pars = NULL)
}
\arguments{
\item{structural_pars}{If \code{NULL} a reduced form model is considered. Reduced models can be used directly as recursively
identified structural models. For a structural model identified by conditional heteroskedasticity, should be a list containing
at least the first one of the following elements:
\itemize{
  \item \code{W} - a \eqn{(dxd)} matrix with its entries imposing constraints on \eqn{W}: \code{NA} indicating that the element is
    unconstrained, a positive value indicating strict positive sign constraint, a negative value indicating strict
    negative sign constraint, and zero indicating that the element is constrained to zero.
  \item \code{C_lambda} - a \eqn{(d(M-1) \times  r)} constraint matrix that satisfies (\strong{\eqn{\lambda}}\eqn{_{2}}\eqn{,...,}
    \strong{\eqn{\lambda}}\eqn{_{M}) =} \strong{\eqn{C_{\lambda} \gamma}} where \strong{\eqn{\gamma}} is the new \eqn{(r \times 1)}
    parameter subject to which the model is estimated (similarly to AR parameter constraints). The entries of \code{C_lambda}
    must be either \strong{positive} or \strong{zero}. Ignore (or set to \code{NULL}) if the eigenvalues \eqn{\lambda_{mi}}
    should not be constrained.
  \item \code{fixed_lambdas} - a length \eqn{d(M-1)} numeric vector (\strong{\eqn{\lambda}}\eqn{_{2}}\eqn{,...,}
    \strong{\eqn{\lambda}}\eqn{_{M})} with elements strictly larger than zero specifying the fixed parameter values for the
    parameters \eqn{\lambda_{mi}} should be constrained to. This constraint is alternative \code{C_lambda}.
    Ignore (or set to \code{NULL}) if the eigenvalues \eqn{\lambda_{mi}} should not be constrained.
}
See Virolainen (forthcoming) for the conditions required to identify the shocks and for the B-matrix as well (it is \eqn{W} times
a time-varying diagonal matrix with positive diagonal entries).}
}
\value{
Returns a list with \code{$W} being \eqn{(d x d)} matrix of NAs and \code{$C_lambda} being \code{NULL}. If the
  supplied argument is \code{NULL}, returns \code{NULL}.
}
\description{
\code{get_unconstrained_struct_pars} return structural parameters that indicate there are no constraints
 (except possibly sign constraints).
}
\details{
Intended to be called after calling the function \code{reform_constrained_pars} to avoid remove the constraints
  again in any further function calls as this will create bugs.
}
\section{Warning}{

 No argument checks!
}

\keyword{internal}
