% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmapsdistance.R
\name{gmapsdistance}
\alias{gmapsdistance}
\title{gmapsdistance}
\usage{
gmapsdistance(
    origin,
    destination,
    combinations = "all",
    mode = "driving",
    key = get.api.key(),
    shape = "wide",
    avoid = "",
    departure = "",
    dep_date = "",
    dep_time = "",
    traffic_model = "None",
    arrival = "",
    arr_date = "",
    arr_time = ""
)
}
\arguments{
\item{origin}{A string or vector of strings containing the description of the
 starting point(s). Should be inside of quotes ("").

 Coordinates in LAT-LONG format are also a valid input as long as they
 can be identified by Google Maps.}

\item{destination}{A string or vector of strings containing the description of
the end point(s). Should be the same format as the variable "origin".}

\item{combinations}{When the origin and destination entries are vectors, the
 user can specify if the function computes all possible combinations
 between origins and destinations, or only pairwise distance and times.
 Should be inside of double quotes (",") and one of the following: "all",
 "pairwise".

 If the combinations is set to "pairwise", the origin and destination vectors
 must have the same length.}

\item{mode}{A string containing the mode of transportation desired. Should be
inside of double quotes (",") and one of the following: "bicycling",
"walking", "transit" or "driving".}

\item{key}{In order to use the Google Maps Distance Matrix API it is necessary
to have an API key. The key should be inside of quotes. Example:
"THISISMYKEY". This key an also be set using \code{set.api.key("THISISMYKEY")}.}

\item{shape}{A string that specifies the shape of the distance and time
 matrices to be returned. Should be inside of double quotes (",") and one
 of the following: "long" or "wide".

 If the function is used to find the distance/time for one origin and one
 destination, the shape does not matter. If there is more than one city as
 origin or destination, "long" will return a matrix in long format and
 "wide" will return a matrix in wide format. The shape is set as wide be
 default.}

\item{avoid}{When the mode is set to "driving", the user can find the time and
distance of the route by avoiding tolls, highways, indoor and ferries.
Should be inside of double quotes (",") and one of the following: "tolls",
"highways", "ferries", "indoor".}

\item{departure}{The time and distance can be computed at the desired time of
 departure. The option departure is the number of seconds since January
 1, 1970 00:00:00 UTC. Alternatively, the user can use the dep_date and
 dep_time options to set the departure date and time.

 If no value is set for departure, dep_date and dep_time, the departure time is
 set to the present.

 Note that API calls that satisfy both of these conditions: 1) departure time
 is specified and  2) travel mode equals "driving" (either directly or via
 fallback to default) incur higher cost.}

\item{dep_date}{Instead of using the departure option, the user can set the
 departure date and time using dep_date and dep_time options.

 If no value is set for departure, dep_date and dep_time, the departure time is
 set to the present.}

\item{dep_time}{Instead of using the departure option, the user can set the
 departure date and time using dep_date and dep_time options.

 If no value is set for departure, dep_date and dep_time, the departure time is
 set to the present.}

\item{traffic_model}{When the mode is set to "driving" and a departure time
 is provided the user can find the times and distances using different traffic
 models. Should be a string and one of the following: "optimistic",
 "pessimistic", "best_guess" or "None".

 Default is "None". The traffic model is not defined for other modes
 of transport than driving, and providing it for e.g. mode = "walking" is illegal.}

\item{arrival}{For transportation mode "transit" the time and distance can
 be computed to arrive at a predetermined time. The option arrival is the
 number of seconds since January 1, 1970 00:00:00 UTC. Alternatively, the
 user can use the arr_date and arr_time options to set the arrival date and time.

 For transport modes other than "transit" the use of arrival (and arr_date
  + arr_time) is illegal.

 The user cannot input both departure and arrival times.}

\item{arr_date}{Instead of using the arrival option, the user can set the
 arrival date and time using arr_date and arr_time options.

 The user cannot input both departure and arrival times.}

\item{arr_time}{Instead of using the arrival option, the user can set the
 arrival date and time using arr_date and arr_time options.

 The user cannot input both departure and arrival times.}
}
\value{
A list with 3 named elements:
\itemize{
   \item{\strong{Distance}: distance between the points provided, taking into
   account mode of transport.}
   \item{\strong{Time}: time of travel, taking into account mode of transport.

   In case departure time was specified, and mode was set to "driving" (either
   directly or via fallback default) the travel time includes delays due to traffic.}
   \item{\strong{Status}: status of the API call.}
 }
}
\description{
Compute Distance with Google Maps
}
\details{
The function gmapsdistance uses the Google Maps Distance Matrix API in order
to compute the distance(s) and time(s) between two points. In order to be able to use the
function you will need an API key and enable the Distance Matrix API in the
Google Developers Console For more information about how to get a key, go to
https://developers.google.com/maps/documentation/distance-matrix/get-api-key#key
For more information about the Google Maps Distance Matrix API go to
https://developers.google.com/maps/documentation/distance-matrix/intro?hl=en
}
\examples{
\dontshow{set.api.key(Sys.getenv("GOOGLE_API_KEY"))}
\dontrun{
# distance from Washington DC to NYC
gmapsdistance(origin = "Washington DC",
              destination = "New York City NY")

# distance matrix between 3 US cities
gmapsdistance(origin = c("Washington DC", "New York NY", "Seattle WA"),
              destination = c("Washington DC", "New York NY", "Seattle WA"))$Distance
}
}
