% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compositionsCompatibility.R
\name{image.logratioVariogramAnisotropy}
\alias{image.logratioVariogramAnisotropy}
\title{Plot variogram maps for anisotropic logratio variograms}
\usage{
\method{image}{logratioVariogramAnisotropy}(
  x,
  jointColor = FALSE,
  breaks = NULL,
  probs = seq(0, 1, 0.1),
  col = spectralcolors,
  ...
)
}
\arguments{
\item{x}{object of class c("logratioVariogramAnisotropy", "logratioVariogram")}

\item{jointColor}{logical, should all variogram maps share the same color scale?}

\item{breaks}{breaks to use in the color scale}

\item{probs}{alternatively to explicit \code{breaks}, these probabilities allow to ask for some equally probable breaks}

\item{col}{either a color palette, or else a vector of colors to use, of length \code{length(breaks)-1}}

\item{...}{additional arguments for generic functionality (currently ignored)}
}
\value{
This function is called for its effect of producing a figure.
Additionally, the graphical parameters active \emph{prior to calling this function} are
returned invisibly.
}
\description{
Image method to obtain variogram maps for anisotropic logratio variograms
}
\examples{
\donttest{
data("jura", package="gstat")
X = jura.pred[,1:2]
Zc = compositions::acomp(jura.pred[,7:9])
vg = logratioVariogram(data=Zc, loc=X, azimuth=c(0:18)*10, 
                           azimuth.tol=22.5)
image(vg)
image(vg, jointColor=TRUE)
}
}
