% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gstatCompatibility.R,
%   R/compositionsCompatibility.R, R/variograms.R
\name{as.gmEVario.gstatVariogram}
\alias{as.gmEVario.gstatVariogram}
\alias{as.gmEVario.logratioVariogram}
\alias{as.gmEVario.logratioVariogramAnisotropy}
\alias{as.gmEVario}
\alias{as.gmEVario.default}
\title{Convert empirical structural function to gmEVario format}
\usage{
\method{as.gmEVario}{gstatVariogram}(vgemp, ...)

\method{as.gmEVario}{logratioVariogram}(vgemp, ...)

\method{as.gmEVario}{logratioVariogramAnisotropy}(vgemp, ...)

as.gmEVario(vgemp, ...)

\method{as.gmEVario}{default}(vgemp, ...)
}
\arguments{
\item{vgemp}{variogram/covariance function to be converted}

\item{...}{further parameters}
}
\value{
the empirical covariance function or variogram, recasted to class
\code{gmEVario}. This is a generic function. Methods exist for objects of
class \code{logratioVariogram}\code{logratioVariogramAnisotropy}
(for compositional data) and \code{gstatVariogram}
(from package \code{gstat}).
}
\description{
Convert empirical covariance functions or variograms to the format gmEVario
of package gmGeostats
}
\section{Methods (by class)}{
\itemize{
\item \code{gstatVariogram}: gstatVariogram method not yet available

\item \code{logratioVariogram}: logratioVariogram method not yet available

\item \code{logratioVariogramAnisotropy}: logratioVariogramAnisotropy method not yet available

\item \code{default}: default method
}}

\seealso{
Other gmEVario functions: 
\code{\link{gsi.EVario2D}()},
\code{\link{gsi.EVario3D}()},
\code{\link{ndirections}()},
\code{\link{plot.gmEVario}()},
\code{\link{variogramModelPlot}()},
\code{\link{variogram}()}
}
\concept{gmEVario functions}
