% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glsm.R
\encoding{UTF-8}
\name{glsm}
\alias{glsm}
\title{Saturated Model Log-Likelihood for Multinomial Outcomes}
\usage{
glsm(formula, data, ref = NaN)
}
\arguments{
\item{formula}{An object of class \code{"formula"} (or one that can be coerced to that class): a symbolic description of the model to be fitted. See 'Details' for more information on model specification.}

\item{data}{An optional data frame, list, or environment (or object coercible via \code{as.data.frame}) containing the variables in the model. If variables are not found in \code{data}, they are taken from \code{environment(formula)}, typically the environment from which \code{glsm()} is called.}

\item{ref}{Optional character string indicating the reference level of the response variable. If not specified, the first level is used by default.}
}
\value{
An object of class \code{"glsm"}, which is a list containing at least the following components:

\item{coefficients}{Vector of estimated coefficients, including intercepts and slopes.}

\item{coef}{Alias for \code{coefficients}. Returns the same vector of estimated intercepts and slopes.}

\item{Std.Error}{Vector of standard errors for the estimated coefficients (intercepts and slopes).}

\item{ExpB}{Vector containing the exponentiated coefficients (i.e., \code{exp(beta)}) for interpretation as odds ratios.}

\item{Wald}{Wald test statistic used to assess the significance of each coefficient (assumed to follow a chi-squared distribution).}

\item{DF}{Degrees of freedom associated with the Wald test's chi-squared distribution.}

\item{P.value}{P-values corresponding to the Wald test statistics.}

\item{Log_Lik_Complete}{Log-likelihood value of the complete model.}

\item{Log_Lik_Null}{Log-likelihood value of the null model.}

\item{Log_Lik_Logit}{Log-likelihood value of the logistic model.}

\item{Log_Lik_Saturate}{Log-likelihood value of the saturated model.}

\item{Populations}{Number of populations considered in the saturated model.}

\item{Dev_Null_vs_Logit}{Deviance statistic comparing the null and logistic models.}

\item{Dev_Logit_vs_Complete}{Deviance statistic comparing the logistic and complete models.}

\item{Dev_Logit_vs_Saturate}{Deviance statistic comparing the logistic and saturated models.}

\item{Df_Null_vs_Logit}{Degrees of freedom for the deviance test comparing the null and logistic models.}

\item{Df_Logit_vs_Complete}{Degrees of freedom for the deviance test comparing the logistic and complete models.}

\item{Df_Logit_vs_Saturate}{Degrees of freedom for the deviance test comparing the logistic and saturated models.}

\item{P.v_Null_vs_Logit}{P-value for the hypothesis test comparing the null and logistic models.}

\item{P.v_Logit_vs_Complete}{P-value for the hypothesis test comparing the logistic and complete models.}

\item{P.v_Logit_vs_Saturate}{P-value for the hypothesis test comparing the logistic and saturated models.}

\item{Logit_r}{Matrix of log-odds values, with respect to the reference category \code{r} of the outcome variable \code{Y}.}

\item{p_hat_complete}{Vector of probabilities that the outcome variable takes the value 1, given the \code{j}th population (estimated from the complete model, excluding the logistic model).}

\item{p_hat_null}{Vector of probabilities that the outcome variable takes the value 1, given the \code{j}th population (estimated from the null model, excluding the logistic model).}

\item{p_rj}{Matrix containing the estimated values of each \code{prj}, the probability that the outcome variable takes the value \code{r}, given the \code{j}th population (estimated using the logistic model).}

\item{odd}{Vector containing the odds for each \code{j}th population.}

\item{OR}{Vector containing the odds ratios for each variable's coefficient.}

\item{z_rj}{Vector containing the values of each \code{Zrj}, defined as the sum of observations in the \code{j}th population.}

\item{nj}{Vector containing the number of observations (\code{nj}) in each \code{j}th population.}

\item{p_rj_tilde}{Vector containing the estimated values of each \code{prj}, the probability that the outcome variable takes the value \code{r}, given the \code{j}th population (estimated under the saturated model, without estimating logistic parameters).}

\item{v_rj}{Vector of variances of the Bernoulli variables in the \code{j}th population and category \code{r}.}

\item{m_rj}{Vector of expected values of \code{Zj} in the \code{j}th population and category \code{r}.}

\item{V_rj}{Vector of variances of \code{Zj} in the \code{j}th population and category \code{r}.}

\item{V}{Variance–covariance matrix of \code{Z}, the vector containing all \code{Zj} values.}

\item{S_p}{Score vector computed under the saturated model.}

\item{I_p}{Fisher information matrix under the saturated model.}

\item{Zast_j}{Vector of standardized values for the variable \code{Zj}.}

\item{mcov}{Variance–covariance matrix of the coefficient estimates.}

\item{mcor}{Correlation matrix of the coefficient estimates.}

\item{Esm}{Estimated Saturated Matrix. A data frame containing estimates from the saturated model. For each population \code{j}, it includes the values of the explanatory variables, \code{nj}, \code{Zrj}, \code{prj_tilde}, and the log-likelihood \code{Lp_tilde}.}

\item{Elm}{Estimated Logit Matrix. A data frame containing estimates from the logistic model. For each population \code{j}, it includes the values of the explanatory variables, \code{nj}, \code{Zrj}, \code{prj}, the logit transformation \code{Logit_rj}, and the variance of the logit (\code{var_logit_rj}).}

\item{call}{The original function call used to fit the glsm model.}
}
\description{
When the response variable \code{Y} takes one of \code{R > 1} values, the function \code{"glsm()"} computes the maximum likelihood estimates (MLEs) of the parameters under four models: null, complete, saturated, and logistic. It also calculates the log-likelihood values for each model.

The method assumes independent, non-identically distributed variables. For grouped data with a multinomial outcome variable, where the observations are divided into \code{J} populations, the function '\code{"glsm()"} offers reliable estimation for any number \code{K} of explanatory variables.
}
\details{
glsm.R

An expression of the form \code{y ~ model} is interpreted as a specification that the response variable \code{y} is modeled by a linear predictor, symbolically defined by \code{model} (the systematic component). The model consists of terms separated by \code{+} operators. Each term can include variable or factor names, and interactions between variables are denoted by \code{:}. Such a term represents the interaction of all included variables and factors. In this context, \code{y} is the outcome variable, which may be binary or polychotomous.
}
\examples{
library(glsm)
data("hsbdemo", package = "glsm")
model <- glsm(prog ~ ses + gender, data = hsbdemo, ref = "academic")
model


}
\references{
Hosmer, D., Lemeshow, S., & Sturdivant, R. (2013). \emph{Applied Logistic Regression} (3rd ed.). New York: Wiley. ISBN: 978-0-470-58247-3
Llinás, H. (2006). Precisiones en la teoría de los modelos logísticos. \emph{Revista Colombiana de Estadística}, 29(2), 239–265.
Llinás, H., & Carreño, C. (2012). The Multinomial Logistic Model for the Case in Which the Response Variable Can Assume One of Three Levels and Related Models. \emph{Revista Colombiana de Estadística}, 35(1), 131–138.
Orozco, E., Llinás, H., & Fonseca, J. (2020). Convergence theorems in multinomial saturated and logistic models. \emph{Revista Colombiana de Estadística}, 43(2), 211–231.
Llinás, H., Arteta, M., & Tilano, J. (2016). El modelo de regresión logística para el caso en que la variable de respuesta puede asumir uno de tres niveles: estimaciones, pruebas de hipótesis y selección de modelos. \emph{Revista de Matemática: Teoría y Aplicaciones}, 23(1), 173–197.
}
\author{
Humberto Llinás (Universidad del Norte, Barranquilla-Colombia; author),
Jorge Villalba (Universidad Tecnológica de Bolívar, Cartagena-Colombia; author and creator),
Jorge Borja (Universidad del Norte, Barranquilla-Colombia; author and creator),
Jorge Tilano (Universidad del Norte, Barranquilla-Colombia; author)
}
