% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_data.R
\docType{data}
\name{glscalibrator_example_metadata}
\alias{glscalibrator_example_metadata}
\alias{glscalibrator_example_files}
\title{Metadata for the bundled GLS example datasets}
\format{
A data frame with 3 rows and 7 variables:
\describe{
  \item{name}{Short identifier used by \code{gls_example()}}
  \item{file}{Filename stored under \code{inst/extdata/}}
  \item{type}{"real" or "synthetic" dataset}
  \item{description}{Summary of the dataset contents}
  \item{duration_days}{Approximate deployment duration represented}
  \item{size_kb}{Approximate file size in kilobytes}
  \item{notes}{Additional guidance for analysis and demonstrations}
}

A data frame (tibble) with metadata for each example dataset.

Named character vector. Use with \code{system.file("extdata", ...)}.
}
\usage{
glscalibrator_example_metadata

glscalibrator_example_files
}
\description{
The package ships with three light-level geolocation (.lux) files that are
used throughout the documentation, vignettes, and tests. This metadata table
records their origin and recommended use so that analysts can reference the
contents programmatically.

Named character vector of the filenames stored in
  \code{inst/extdata/}, keyed by the identifiers recognised by
  \code{gls_example()}.
}
\details{
All files are plain-text .lux exports that can be read directly with
\code{read_lux_file()}. Real datasets were collected from tropical seabirds
breeding near 27.85°N, 115.17°W and are approved for demonstration and
teaching purposes. The synthetic dataset contains idealised sunrise/sunset
curves for rapid testing.
}
\seealso{
\code{gls_example()}, \code{list_gls_examples()}
}
\keyword{datasets}
