% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_twilights.R
\name{filter_twilights}
\alias{filter_twilights}
\title{Filter and Clean Twilight Data}
\usage{
filter_twilights(twilights, light_data = NULL, threshold = 2, strict = TRUE)
}
\arguments{
\item{twilights}{A data.frame with columns \code{Twilight} and \code{Rise}}

\item{light_data}{The original light data (optional, for quality checks)}

\item{threshold}{Light threshold used for twilight detection}

\item{strict}{Logical, if TRUE applies stricter filtering (default: TRUE)}
}
\value{
A filtered data.frame of twilights
}
\description{
Applies quality filters to twilight data to remove spurious detections
caused by shading, logger malfunction, or other artifacts.
}
\details{
Filters applied:
\itemize{
  \item Remove twilights too close together (< 1-2 hours)
  \item Remove twilights with unusual intervals (far from 12 or 24 hours)
  \item Optionally check light quality around twilight (if light_data provided)
}
}
\examples{
# Filter twilights from example data
example_file <- gls_example("W086")
light_data <- read_lux_file(example_file)
twilights <- detect_twilights(light_data, threshold = 2)
twilights_clean <- filter_twilights(twilights, light_data, threshold = 2)
nrow(twilights_clean)

}
