% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmFEL-helpers.R
\name{glmmfe_new_fit}
\alias{glmmfe_new_fit}
\title{Construct a glmmFEL fitted-model object}
\usage{
glmmfe_new_fit(
  y,
  X,
  Z,
  beta,
  eta,
  tau2,
  G = NULL,
  vcov_beta = NULL,
  vcov_eta = NULL,
  cov_beta_eta = NULL,
  var_eta = NULL,
  family,
  approx,
  control,
  convergence,
  logLik = NA_real_,
  call = NULL,
  reml = NULL
)
}
\arguments{
\item{y}{Numeric response vector of length \code{n}.}

\item{X}{Fixed-effects design matrix \verb{n x p}.}

\item{Z}{Random-effects design matrix \verb{n x q} (stored as sparse dgCMatrix).}

\item{beta}{Fixed-effect estimates (length \code{p}).}

\item{eta}{Random-effect predictions (length \code{q}).}

\item{tau2}{Non-negative scalar variance component.}

\item{G}{Optional \verb{q x q} covariance matrix (defaults to \code{tau2 * I_q}).}

\item{vcov_beta}{Optional \verb{p x p} covariance matrix for \code{beta}.}

\item{vcov_eta}{Optional \verb{q x q} covariance matrix for \code{eta}.}

\item{cov_beta_eta}{Optional \verb{p x q} cross-covariance block.}

\item{var_eta}{Optional alias for prediction-error covariance of \code{eta}.}

\item{family}{Canonical family label.}

\item{approx}{Canonical approximation label.}

\item{control}{List of control settings used.}

\item{convergence}{List containing convergence information.}

\item{logLik}{Approximate log-likelihood/objective (may be NA).}

\item{call}{Captured match.call().}

\item{reml}{Logical flag (used by RSPL/MSPL only; may be NULL otherwise).}
}
\value{
A list of class \code{c("glmmFELMod", "glmmFEL")}.
}
\description{
Internal helper to standardize creation of the fitted-model object returned
by \code{\link[=glmmFEL]{glmmFEL()}} and related engines.

This branch stores only a single variance component \code{tau2} with
\eqn{G = \tau^2 I_q}. More structured covariance parameterizations and the
formula wrapper are intentionally removed to reduce complexity.
}
\keyword{internal}
