% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.rankComp.R
\name{summary.rankComp}
\alias{summary.rankComp}
\alias{print.summary.rankComp}
\title{Summarizing Ranking Comparison}
\usage{
\method{summary}{rankComp}(object, n.pick = 10L, n.q = 10L, ...)

\method{print}{summary.rankComp}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{object}{an object of class \code{"rankComp"}, usually, an output of a call
to \code{\link{rankComp}}.}

\item{n.pick}{a positive integer specifying the number of units considered to
form the top/bottom based on the alternative index. The default value is \code{10}.}

\item{n.q}{a positive integer specifying the n-quantiles considered
to compute quantile rankings. The default value is \code{10} (deciles).}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class \code{"summary.rankComp"}, usually, a output of a call
to \code{\link{summary.rankComp}}.}

\item{digits}{number of significant digits to use when printing.}
}
\value{
An object of class \code{"summary.rankComp"} which is a list of components:
\item{par}{a vector storing the values of \code{n.pick} and \code{n.q}.}
\item{n.unit}{the number of ranked units (by temporal factors if available).}
\item{shift.stats}{a data frame with rows presenting the summary statistics
of ranking shifts: minimum, first quartile, median, mean, third quartile,
and maximum.}
\item{asr}{a data frame giving the average shift in ranking (ASR)
\deqn{\mathrm{ASR} = \frac{1}{m} \sum^m_{i = 1}
  | \mathrm{rank}^{\mathrm{alt}}_i - \mathrm{rank}^{\mathrm{ref}}_i |,}
where \eqn{m} is the number of units considered. The rows present the ASR
for all units, and for the top and the bottom units based on the
alternative index ranking.}
\item{per}{a data frame giving the percentage of equal rankings (PER)
\deqn{\mathrm{PER} = 100 \times \frac{1}{m} \sum^m_{i = 1}
  \{ \mathrm{rank}^{\mathrm{alt}}_i = \mathrm{rank}^{\mathrm{ref}}_i \},}
where \eqn{m} is the number of units considered. The rows present the PER
for all units, and for the top and the bottom units based on the
alternative index ranking.}
\item{asq}{the average shift in quantile ranking (by temporal factors if
available). This value is similar to the ASR for all units, but using the
quantile ranking of two indices.}
For \code{shift.stats}, \code{asr}, and \code{per}, multiple columns will be generated
according to temporal factors if \code{object$time} is not \code{NULL}.
}
\description{
Summary method for class \code{"rankComp"} and print method for class
\code{"summary.rankComp"}.
}
\details{
\code{summary.rankComp} provides details on the ranking comparison between the
reference and the alternative indices stored in the object of class
\code{"rankComp"}. \code{print.summary.rankComp} prints summary information using a
smart digit format for the components.
}
\examples{
data(bli)

# Goalpost normalization
bli.pol = c("neg", "pos", "pos", "pos", "pos", "neg",
            "pos", "pos", "pos", "neg", "pos")
bli.norm.2014 <- normalize(inds = bli[, 3:13], method = "goalpost",
                           ind.pol = bli.pol, time = bli$YEAR,
                           ref.time = 2014)

# Composite indices
ci.gini <- giniCI(bli.norm.2014, method = "gini",
                  ci.pol = "pos", time = bli$YEAR, ref.time = 2014,
                  only.ci = TRUE)
ci.reci <- giniCI(bli.norm.2014, method = "reci", agg = "geo",
                  ci.pol = "pos", time = bli$YEAR, ref.time = 2014,
                  only.ci = TRUE)

# Ranking comparison
ci.comp <- rankComp(ci.gini, ci.reci, id = bli$COUNTRY, time = bli$YEAR)
print(ci.comp)
summary(ci.comp)
}
\references{
Mariani, F., Ciommi, M., & Recchioni, M. C. (2024). Two in One: A New Tool
to Combine Two Rankings Based on the Voronoi Diagram. \emph{Social Indicators
Research}, 175, 989--1005.
}
\seealso{
\code{\link{rankComp}}.
}
\author{
Viet Duong Nguyen, Chiara Gigliarano, Mariateresa Ciommi
}
