% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_table.R
\name{genes_table}
\alias{genes_table}
\title{Combine a ggplot Object with a Table of Genes}
\usage{
genes_table(plot_obj, data2)
}
\arguments{
\item{plot_obj}{A ggplot object, typically the output of a plotting function.}

\item{data2}{A data frame containing gene details. It should have columns named
"genes", "baseMean", "log2FoldChange", "pvalue", and "padj".}
}
\value{
A gtable object showing the ggplot stacked above a table of gene details.
}
\description{
This function takes a ggplot object and a data frame of gene details and
produces a combined plot where the ggplot object is stacked above a table of
gene details.
}
\examples{
# Load example datasets
data(all_genes)
data(attention_genes)

# Create a volcano plot highlighting genes of interest
plot <- ggvolc(all_genes, attention_genes, add_seg = TRUE)

# Combine the plot with a table showing gene statistics
# The table includes: gene names, baseMean, log2FoldChange, pvalue, and padj
genes_table(plot, attention_genes)

}
