% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_upset.R
\name{scale_x_mergelist}
\alias{scale_x_mergelist}
\title{Merge list columns into character vectors}
\usage{
scale_x_mergelist(sep = "-", ..., position = "bottom")
}
\arguments{
\item{sep}{String the is used to delimit the elements in each list entry.
Default: "-".}

\item{...}{additional arguments that are passed on to
\code{ggplot2::scale_x_discrete}}

\item{position}{either "top" or "bottom" to specify where the
x axis drawn. Default: "bottom"}
}
\description{
The function handles list columns by collapsing them into delimited strings
using the \code{sep} argument. This is useful to show sets and in combination
with the \code{axis_combmatrix()} function.
}
\examples{
library(ggplot2)
ggplot(tidy_movies[1:100, ], aes(x=Genres)) +
  geom_bar() +
  scale_x_mergelist() +
  theme(axis.text.x = element_text(angle = 90, hjust=1, vjust = 0.5))

ggplot(tidy_movies[1:100, ], aes(x=Genres)) +
  geom_bar() +
  scale_x_mergelist(sep = " & ", name = "Merged Movie Genres", position = "top") +
  theme(axis.text.x = element_text(angle = 90, hjust=0, vjust = 0.5))


}
\seealso{
\code{\link[ggplot2]{discrete_scale}}
}
