% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-helpers.R
\name{gg_tsdisplay}
\alias{gg_tsdisplay}
\title{Ensemble of time series displays}
\usage{
gg_tsdisplay(
  data,
  y = NULL,
  plot_type = c("auto", "partial", "season", "histogram", "scatter", "spectrum"),
  lag_max = NULL
)
}
\arguments{
\item{data}{A tidy time series object (tsibble)}

\item{y}{The variable to plot (a bare expression). If NULL, it will
automatically selected from the data.}

\item{plot_type}{type of plot to include in lower right corner. By default
(\code{"auto"}) a season plot will be shown for seasonal data, a spectrum plot
will be shown for non-seasonal data without missing values, and a PACF will
be shown otherwise.}

\item{lag_max}{maximum lag at which to calculate the acf. Default is 10*log10(N/m)
where N is the number of observations and m the number of series. Will be
automatically limited to one less than the number of observations in the series.}
}
\value{
A list of ggplot objects showing useful plots of a time series.
}
\description{
Plots a time series along with its ACF along with an customisable third
graphic of either a PACF, histogram, lagged scatterplot or spectral density.
}
\examples{
library(tsibble)
library(dplyr)
tsibbledata::aus_retail \%>\%
  filter(
    State == "Victoria",
    Industry == "Cafes, restaurants and catering services"
  ) \%>\%
  gg_tsdisplay(Turnover)

}
\references{
Hyndman and Athanasopoulos (2019) \emph{Forecasting: principles
and practice}, 3rd edition, OTexts: Melbourne, Australia.
\url{https://OTexts.com/fpp3/}
}
\seealso{
\code{\link[stats]{plot.ts}}, \code{\link[feasts:ACF]{feasts::ACF()}},
\code{\link[stats]{spec.ar}}
}
\author{
Rob J Hyndman & Mitchell O'Hara-Wild
}
