% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reveal_panels.R
\name{reveal_panels}
\alias{reveal_panels}
\title{Reveal plot by panel}
\usage{
reveal_panels(p, order = NULL, what = c("data", "everything"))
}
\arguments{
\item{p}{A ggplot2 object}

\item{order}{(optional) A numeric vector specifying in which order to reveal the panels

For example, if there are three panels in the plot, \code{order = c(3, 2, 1)} will invert the
order in which they are revealed.

Any panel not included in the vector will be omitted from the incremental
plots. E.g.: with \code{order = c(3, 1)}, the second panel is not shown.

By default, the first plot is blank, showing layout elements (title,
legends, axes, etc) but no data. To omit the blank plot, include \code{-1}: e.g.
\code{order = c(-1, 3, 1)}, or \code{order = -1}.}

\item{what}{(optional) one of \code{"data"} or \code{"everything"}.' With \code{"data"} (the
default), the basic graph layout, including axes and facet labels, is shown
from the start, and only the data points are shown incrementally. With
\code{"everything"}, the entire panels are shown incrementally.}
}
\value{
A list of ggplot2 objects, which can be passed to \code{\link[=reveal_save]{reveal_save()}}
}
\description{
Turns a ggplot into a list of plots, showing data incrementally by panels.
}
\examples{
# Create full plot
library(ggplot2)
data("mtcars")

p <- mtcars |>
  ggplot(aes(mpg, wt,
             color = factor(vs),
             group = factor(vs))) +
  geom_point() +
  geom_smooth(method="lm",
              formula = 'y ~ x',
              linewidth=1) +
  facet_wrap(~am)
p

# Only data
plot_list <- reveal_panels(p, what = "data")
plot_list[[1]]
plot_list[[2]]
plot_list[[3]]

# Everything
plot_list <- reveal_panels(p, what = "everything")
plot_list[[1]]
plot_list[[2]]
plot_list[[3]]

# Save plots
reveal_save(plot_list, "myplot.png", width = 8, height = 4, path = tempdir())

# Clean temp files
file.remove(list.files(path = tempdir(), pattern = "myplot", full.names = TRUE)) 
}
