% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reveal_axis.R
\name{reveal_x}
\alias{reveal_x}
\alias{reveal_y}
\title{Reveal plot by axis}
\usage{
reveal_x(p, order = NULL)

reveal_y(p, order = NULL)
}
\arguments{
\item{p}{A ggplot2 object}

\item{order}{(optional) A numeric vector specifying in which order to reveal the categories

For example, if there are three categories in the axis, \code{order = c(3, 2, 1)} will invert the order in which they are revealed.

Any category not included in the vector will be omitted from the incremental
plots. E.g.: with \code{order = c(3, 1)}, the second category is not shown.

By default, the first plot is blank, showing layout elements (title,
legends, axes, etc) but no data. To omit the blank plot, include \code{-1}: e.g.
\code{order = c(-1, 3, 1)}, or \code{order = -1}.}
}
\value{
A list of ggplot2 objects, which can be passed to \code{\link[=reveal_save]{reveal_save()}}
}
\description{
Turns a ggplot into a list of plots, showing data incrementally by the
categories in the x or y axis.
}
\examples{
# Create full plot
library(ggplot2)
data("mtcars")

p <- mtcars |>
  ggplot(aes(factor(vs), 
             color = gear,
             fill= gear, 
             group = gear)) +
  geom_bar() +
  facet_wrap(~am)
p

plot_list <- reveal_x(p)
plot_list[[1]]
plot_list[[2]]
plot_list[[3]]

# Save plots
reveal_save(plot_list, "myplot.png", width = 8, height = 4, path = tempdir())

# Clean temp files
file.remove(list.files(path = tempdir(), pattern = "myplot", full.names = TRUE)) 
}
