% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_conf.R
\name{gg_conf}
\alias{gg_conf}
\title{Confusion/Contingency Table Bubble Plot}
\usage{
gg_conf(
  data,
  x,
  y,
  fill = "skyblue",
  text_size = 4,
  text_color = "black",
  point_size_range = c(3, 15),
  border_color = "black",
  show_grid = TRUE,
  expand = 0.15,
  facet_x = NULL,
  facet_y = NULL
)
}
\arguments{
\item{data}{A data frame containing the categorical variables.}

\item{x}{Character string specifying the column name in \code{data} for
the x-axis categorical variable.}

\item{y}{Character string specifying the column name in \code{data} for
the y-axis categorical variable.}

\item{fill}{Character string specifying the fill color for bubbles.
Default is "skyblue".}

\item{text_size}{Numeric value specifying the size of count labels.
Default is 4.}

\item{text_color}{Character string specifying the color of count labels.
Default is "black".}

\item{point_size_range}{Numeric vector of length 2 specifying the minimum
and maximum bubble sizes. Default is \code{c(3, 15)}.}

\item{border_color}{Character string specifying the color of bubble borders.
Default is "black".}

\item{show_grid}{Logical indicating whether to show major grid lines.
Default is TRUE.}

\item{expand}{Numeric value specifying the expansion multiplier for both
axes. Default is 0.15.}

\item{facet_x}{Character string specifying an optional column name in
\code{data} for horizontal faceting. Default is NULL (no faceting).}

\item{facet_y}{Character string specifying an optional column name in
\code{data} for vertical faceting. Default is NULL (no faceting).}
}
\value{
A ggplot2 object showing the confusion table as a bubble plot.
The plot displays:
\itemize{
\item Bubbles at each x-y combination, sized by frequency count
\item Count labels displayed in the center of each bubble
\item Optional faceting for additional categorical variables
\item Customizable colors, sizes, and grid visibility
}
}
\description{
The function automatically computes frequency counts for each unique
combination of the x and y categorical variables using \code{table()}.
Bubble sizes are scaled proportionally to represent counts, with the
range controlled by \code{point_size_range}. Useful for visualizing
cross-tabulations, confusion matrices, or any bivariate categorical data.
}
\examples{
data(mtcars)
# Create synthetic categorical variables
# Bin horsepower & fuel efficiency into ordered categories
mtcars$horsepower <- 
  cut(mtcars$hp, breaks = 5, 
      labels = c("Very Low", "Low", "Medium", "High", "Very High"))
mtcars$`miles per gallon` <- 
  cut(mtcars$mpg, breaks = 5,
      labels = c("Very Low", "Low", "Medium", "High", "Very High"))

# Base plot
gg_conf(data = mtcars, x = "horsepower", y = "miles per gallon")

# Custom styling
gg_conf(data = mtcars, x = "horsepower", y = "miles per gallon",
        fill = "lightcoral", point_size_range = c(5, 20),
        show_grid = FALSE)

# With faceting by "vs" column
gg_conf(data = mtcars, x = "horsepower", y = "miles per gallon",
        fill = "lightcoral", point_size_range = c(5, 20),
        facet_x = "vs",
        show_grid = FALSE)
}
