% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-quadrant-counts.R
\name{stat_quadrant_counts}
\alias{stat_quadrant_counts}
\title{Number of observations in quadrants}
\usage{
stat_quadrant_counts(
  mapping = NULL,
  data = NULL,
  geom = "text_npc",
  position = "identity",
  quadrants = NULL,
  pool.along = c("none", "x", "y", "xy"),
  xintercept = 0,
  yintercept = 0,
  label.x = NULL,
  label.y = NULL,
  digits = 2,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs to be
set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use on this layer}

\item{quadrants}{integer vector indicating which quadrants are of interest,
with a \code{OL} indicating the whole plot.}

\item{pool.along}{character, one of \code{"none"}, \code{"x"} or \code{"y"},
indicating which quadrants to pool to calculate counts by pair of
quadrants.}

\item{xintercept, yintercept}{numeric the coordinates of the origin of the
quadrants.}

\item{label.x, label.y}{\code{numeric} Coordinates (in npc units) to be used
for absolute positioning of the labels.}

\item{digits}{integer Number of digits for fraction and percent labels.}

\item{na.rm}{a logical indicating whether \code{NA} values should be stripped
before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and should not inherit behaviour from the
default plot specification, e.g., \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\value{
A plot layer instance. Using as output \code{data} the counts of
  observations per plot quadrant.
}
\description{
\code{stat_quadrant_counts()} counts the number of observations in each
quadrant of a plot panel. By default it adds a text label to the far corner
of each quadrant. It can also be used to obtain the total number of
observations in each of two pairs of quadrants or in the whole panel.
Grouping is ignored, so en every case a single count is computed for each
quadrant in a plot panel.
}
\details{
This statistic can be used to automatically count observations in
  each of the four quadrants of a plot, and by default add these counts as
  text labels. Values exactly equal to \code{xintercept} or
  \code{yintercept} are counted together with those larger than the
  intercepts. An argument value of zero, passed to formal parameter
  \code{quadrants} is interpreted as a request for the count of all
  observations in each plot panel.

  The default origin of quadrants is at \code{xintercept = 0},
  \code{yintercept = 0}. Also by default, counts are computed for all
  quadrants within the \emph{x} and \emph{y} scale limits, but ignoring any
  marginal scale expansion. The default positions of the labels is in the
  farthest corner or edge of each quadrant using npc coordinates.
  Consequently, when using facets even with free limits for \emph{x} and
  \emph{y} axes, the location of the labels is consistent across panels. This
  is achieved by use of \code{geom = "text_npc"} or \code{geom =
  "label_npc"}. To pass the positions in native data units, pass \code{geom =
  "text"} explicitly as argument.
}
\section{Computed variables}{
 Data frame with one to four rows, one for each
  quadrant for which counts are counted in \code{data}. \describe{
  \item{quadrant}{integer, one of 0:4} \item{x}{x value of label position in
  data units} \item{y}{y value of label position in data units} \item{npcx}{x
  value of label position in npc units} \item{npcy}{y value of label position
  in npc units} \item{count}{number of  observations in the quadrant(s)}
  \item{total}{number of onservations in data}
  \item{count.label}{number of observations as character}
  \item{pc.label}{percent of observations as character}
  \item{fr.label}{fraction of observations as character} }.

  As shown in one example below \code{\link[gginnards]{geom_debug}} can be
  used to print the computed values returned by any statistic. The output
  shown includes also values mapped to aesthetics, like \code{label} in the
  example.
}

\examples{

# generate artificial data
set.seed(4321)
x <- -50:50
y <- rnorm(length(x), mean = 0)
my.data <- data.frame(x, y)

# using automatically generated text labels, default origin at (0, 0)

ggplot(my.data, aes(x, y)) +
  geom_point() +
  geom_quadrant_lines() +
  stat_quadrant_counts()

ggplot(my.data, aes(x, y)) +
  geom_point() +
  geom_quadrant_lines() +
  stat_quadrant_counts(aes(label = after_stat(pc.label)))

ggplot(my.data, aes(x, y)) +
  geom_point() +
  geom_quadrant_lines() +
  stat_quadrant_counts(aes(label = after_stat(fr.label)))

ggplot(my.data, aes(x, y)) +
  geom_point() +
  geom_quadrant_lines() +
  stat_quadrant_counts(aes(label = after_stat(dec.label)))

ggplot(my.data, aes(x, y)) +
 geom_point() +
  geom_quadrant_lines() +
  stat_quadrant_counts(aes(label = sprintf("\%i observations", after_stat(count)))) +
  scale_y_continuous(expand = expansion(c(0.05, 0.15))) # reserve space

# user specified origin

ggplot(my.data, aes(x, y)) +
  geom_quadrant_lines(colour = "blue", xintercept = 10, yintercept = -1) +
  stat_quadrant_counts(colour = "blue", xintercept = 10, yintercept = -1) +
  geom_point() +
  scale_y_continuous(expand = expansion(mult = 0.15))

ggplot(my.data, aes(x, y)) +
  geom_quadrant_lines(colour = "blue", xintercept = 10, yintercept = -1) +
  stat_quadrant_counts(aes(label = after_stat(pc.label)),
                       colour = "blue", xintercept = 10, yintercept = -1) +
  geom_point() +
  scale_y_continuous(expand = expansion(mult = 0.15))

# more digits in labels

ggplot(my.data, aes(x, y)) +
  geom_quadrant_lines(colour = "blue", xintercept = 10, yintercept = -1) +
  stat_quadrant_counts(aes(label = after_stat(pc.label)), digits = 3,
                       colour = "blue", xintercept = 10, yintercept = -1) +
  geom_point() +
  scale_y_continuous(expand = expansion(mult = 0.15))

ggplot(my.data, aes(x, y)) +
  geom_quadrant_lines(colour = "blue", xintercept = 10, yintercept = -1) +
  stat_quadrant_counts(aes(label = after_stat(fr.label)),
                       colour = "blue", xintercept = 10, yintercept = -1) +
  geom_point() +
  scale_y_continuous(expand = expansion(mult = 0.15))

# grouped quadrants

ggplot(my.data, aes(x, y)) +
  geom_quadrant_lines(colour = "blue",
                      pool.along = "x") +
  stat_quadrant_counts(colour = "blue", label.x = "right",
                       pool.along = "x") +
  geom_point() +
  scale_y_continuous(expand = expansion(mult = 0.15))

# whole panel

ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_quadrant_counts(quadrants = 0, label.x = "left", label.y = "bottom") +
  scale_y_continuous(expand = expansion(mult = c(0.15, 0.05)))

# use a different geometry

ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_quadrant_counts(geom = "text") # use geom_text()

# Numeric values can be used to build labels with alternative formats
# Here with sprintf(), but paste() and format() also work.

ggplot(my.data, aes(x, y)) +
  geom_quadrant_lines(colour = "blue") +
  stat_quadrant_counts(aes(label = sprintf("\%i of \%i genes",
                       after_stat(count), after_stat(total))),
                       colour = "blue") +
  geom_point() +
  scale_y_continuous(expand = expansion(mult = 0.15))

# We use geom_debug_group() to see the computed values

gginnards.installed <- requireNamespace("gginnards", quietly = TRUE)
if (gginnards.installed) {
  library(gginnards)

  ggplot(my.data, aes(x, y)) +
    geom_point() +
    stat_quadrant_counts(geom = "debug_group")
}

if (gginnards.installed) {
  ggplot(my.data, aes(x, y)) +
    geom_point() +
    stat_quadrant_counts(geom = "debug_group", xintercept = 50)
}

}
\seealso{
Other Functions for quadrant and volcano plots: 
\code{\link{geom_quadrant_lines}()},
\code{\link{stat_panel_counts}()}
}
\concept{Functions for quadrant and volcano plots}
