% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_gsea.R
\name{create_heatmap_plot}
\alias{create_heatmap_plot}
\title{Create heatmap visualization of GSEA results}
\usage{
create_heatmap_plot(
  gsea_results,
  abundance,
  metadata,
  group,
  n_pathways = 20,
  cluster_rows = TRUE,
  cluster_columns = TRUE,
  show_rownames = TRUE,
  annotation_colors = NULL,
  col_fun = NULL
)
}
\arguments{
\item{gsea_results}{A data frame containing GSEA results from the pathway_gsea function}

\item{abundance}{A data frame containing the original abundance data}

\item{metadata}{A data frame containing sample metadata}

\item{group}{A character string specifying the column name in metadata that contains the grouping variable}

\item{n_pathways}{An integer specifying the number of pathways to display}

\item{cluster_rows}{A logical value indicating whether to cluster rows}

\item{cluster_columns}{A logical value indicating whether to cluster columns}

\item{show_rownames}{A logical value indicating whether to show row names}

\item{annotation_colors}{A list of colors for annotations}

\item{col_fun}{A color function (e.g., circlize::colorRamp2) to control the main heatmap colors (optional)}
}
\value{
A ComplexHeatmap object
}
\description{
Create heatmap visualization of GSEA results
}
\keyword{internal}
