% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpedigreeHelpers.R
\name{recodeMissingIDs}
\alias{recodeMissingIDs}
\title{Recode Missing IDs in Pedigree Data}
\usage{
recodeMissingIDs(
  ped,
  momID = "momID",
  dadID = "dadID",
  personID = "personID",
  famID = "famID",
  matID = "matID",
  patID = "patID",
  missing_code_numeric = 0,
  missing_code_character = c("0", "NA", "na", ""),
  config = list()
)
}
\arguments{
\item{ped}{A data frame containing the pedigree data. Needs personID, momID, dadID, and sex columns.}

\item{momID}{Character string specifying the column name for mother IDs. Defaults to "momID".}

\item{dadID}{Character string specifying the column name for father IDs. Defaults to "dadID".}

\item{personID}{Character string specifying the column name for individual IDs. Defaults to "personID".}

\item{famID}{Character string specifying the column name for family IDs. Defaults to "famID".}

\item{matID}{Character string specifying the column name for maternal lines Defaults to "matID".}

\item{patID}{Character string specifying the column name for paternal lines Defaults to "patID".}

\item{missing_code_numeric}{Numeric code representing missing IDs (default is 0).}

\item{missing_code_character}{Character vector representing missing IDs (default is c("0", "NA", "na", "")).}

\item{config}{A list of configuration options for customizing the plot.
      See getDefaultPlotConfig for details of each option. The list can include:
\describe{
   \item{code_male}{Integer or string. Value identifying males in the sex column. (typically 0 or 1) Default: 1}
   \item{segment_spouse_color, segment_self_color}{Character. Line colors for respective connection types.}
   \item{segment_sibling_color, segment_parent_color, segment_offspring_color}{Character. Line colors for respective connection types.}
   \item{label_text_size, point_size, segment_linewidth}{Numeric. Controls text size, point size, and line thickness.}
   \item{generation_height}{Numeric. Vertical spacing multiplier between generations. Default: 1.}
   \item{shape_unknown, shape_female, shape_male, status_shape_affected}{Integers. Shape codes for plotting each group.}
   \item{sex_shape_labels}{Character vector of labels for the sex variable. (default: c("Female", "Male", "Unknown"))}
   \item{unaffected, affected}{Values indicating unaffected/affected status.}
   \item{sex_color_include}{Logical. If TRUE, uses color to differentiate sex.}
   \item{label_max_overlaps}{Maximum number of overlaps allowed in repelled labels.}
   \item{label_segment_color}{Color used for label connector lines.}
 }}
}
\value{
A data frame with missing IDs recoded to NA.
}
\description{
This function recodes missing IDs in the pedigree data frame to NA.
It checks for specified missing codes (both numeric and character) in their respective columns.
}
\keyword{internal}
