% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggRelatednessMatrix.R
\name{ggRelatednessMatrix}
\alias{ggRelatednessMatrix}
\title{Plot a relatedness matrix as a heatmap (ggpedigree style)}
\usage{
ggRelatednessMatrix(
  mat,
  config = list(),
  interactive = FALSE,
  tooltip_columns = NULL,
  personID = "personID",
  ...
)
}
\arguments{
\item{mat}{A square numeric matrix of relatedness values (precomputed, e.g., from ped2add).}

\item{config}{A list of graphical and display parameters.
See Details for available options.}

\item{interactive}{Logical; if TRUE, returns an interactive plotly object.}

\item{tooltip_columns}{A character vector of column names to include in tooltips.}

\item{personID}{Character; name of the column containing unique person identifiers.}

\item{...}{Additional arguments passed to ggplot2 layers.}
}
\value{
A ggplot object displaying the relatedness matrix as a heatmap.
}
\description{
Plots a relatedness matrix using ggplot2 with config options.
}
\details{
Config options include:
 \describe{
  \item{matrix_color_palette}{A vector of colors for the heatmap (default: Reds scale)}
  \item{color_scale_midpoint}{Numeric midpoint for diverging color scale (default: 0.25)}
  \item{plot_title}{Plot title}
  \item{matrix_cluster}{Logical; should rows/cols be clustered (default: TRUE)}
  \item{axis_x_label, axis_y_label}{Axis labels}
  \item{axis_text_size}{Axis text size}
}
}
\examples{
# Example relatedness matrix
set.seed(123)
mat <- matrix(runif(100, 0, 1), nrow = 10)
rownames(mat) <- paste0("ID", 1:10)
colnames(mat) <- paste0("ID", 1:10)

# Plot the relatedness matrix
ggRelatednessMatrix(mat,
  config = list(
    matrix_color_palette = c("white", "gold", "red"),
    color_scale_midpoint = 0.5,
    matrix_cluster = TRUE,
    plot_title = "Relatedness Matrix",
    axis_x_label = "Individuals",
    axis_y_label = "Individuals",
    axis_text_size = 8
  )
)
}
\seealso{
ggRelatednessMatrix.core, vignette("v30_matrix")
}
