% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcConnections.R
\name{calculateConnections}
\alias{calculateConnections}
\title{Calculate connections for a pedigree dataset}
\usage{
calculateConnections(
  ped,
  config = list(),
  spouseID = "spouseID",
  personID = "personID",
  momID = "momID",
  famID = "famID",
  twinID = "twinID",
  dadID = "dadID"
)
}
\arguments{
\item{ped}{A data frame containing the pedigree data. Needs personID, momID, dadID, and sex columns.}

\item{config}{List of configuration parameters. Currently unused but passed through to internal helpers.}

\item{spouseID}{Character string specifying the column name for spouse IDs. Defaults to "spouseID".}

\item{personID}{Character string specifying the column name for individual IDs. Defaults to "personID".}

\item{momID}{Character string specifying the column name for mother IDs. Defaults to "momID".}

\item{famID}{Character string specifying the column name for family IDs. Defaults to "famID".}

\item{twinID}{Character string specifying the column name for twin IDs. Defaults to "twinID".}

\item{dadID}{Character string specifying the column name for father IDs. Defaults to "dadID".}
}
\value{
A `data.frame` containing connection points and midpoints for graphical rendering. Includes:
  \itemize{
    \item `x_pos`, `y_pos`: positions of focal individual
    \item `x_dad`, `y_dad`, `x_mom`, `y_mom`: parental positions (if available)
    \item `x_spouse`, `y_spouse`: spousal positions (if available)
    \item `x_mid_parent`, `y_mid_parent`: midpoint between parents
    \item `x_mid_sib`, `y_mid_sib`: sibling group midpoint
    \item `x_mid_spouse`, `y_mid_spouse`: midpoint between spouses
  }
}
\description{
Computes graphical connection paths for a pedigree layout, including parent-child,
sibling, and spousal connections. Optionally processes duplicate appearances
of individuals (marked as `extra`) to ensure relational accuracy.
}
\examples{
ped <- data.frame(
  personID = c("A", "B", "C", "D", "X"),
  momID = c(NA, "A", "A", "C", NA),
  dadID = c(NA, "X", "X", "B", NA),
  spouseID = c("X", "C", "B", NA, "A"),
  sex = c("F", "M", "F", "F", "M")
)

coords <- calculateCoordinates(ped, code_male = "M")
conns <- calculateConnections(coords, config = list(code_male = "M"))
names(conns)
head(conns$connections)

}
\seealso{
calculateCoordinates, ggPedigree, vignette("v00_plots")
}
