% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_layers.R
\name{nn_lstm_step}
\alias{nn_lstm_step}
\title{Build one LSTM step}
\usage{
nn_lstm_step(
  ctx,
  x_t,
  h_t,
  c_t,
  W_gates,
  U_gates,
  b_gates,
  units,
  act_cell,
  act_rec
)
}
\arguments{
\item{ctx}{ggml compute context}

\item{x_t}{Input at this step: tensor [input_size, N]}

\item{h_t}{Previous hidden state: tensor [units, N]}

\item{c_t}{Previous cell state: tensor [units, N]}

\item{W_gates}{[input_size, 4*units]}

\item{U_gates}{[units, 4*units]}

\item{b_gates}{[4*units]}

\item{units}{Integer}

\item{act_cell}{Activation name for cell gate (tanh by default)}

\item{act_rec}{Activation name for i/f/o gates (sigmoid by default)}
}
\value{
list(h = new_h, c = new_c)
}
\description{
Build one LSTM step
}
\keyword{internal}
