% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_model.R
\name{ggml_pop_layer}
\alias{ggml_pop_layer}
\title{Remove the Last Layer from a Sequential Model}
\usage{
ggml_pop_layer(model)
}
\arguments{
\item{model}{A ggml_sequential_model object}
}
\value{
The model with the last layer removed.
}
\description{
Removes the last layer from the model. The model must not be compiled.
}
\examples{
\donttest{
model <- ggml_model_sequential() |>
  ggml_layer_dense(64, activation = "relu") |>
  ggml_layer_dense(10, activation = "softmax")

model <- ggml_pop_layer(model)
length(model$layers)  # 1
}
}
