% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_layers.R
\name{ggml_layer_dense}
\alias{ggml_layer_dense}
\title{Add Dense (Fully Connected) Layer}
\usage{
ggml_layer_dense(
  model,
  units,
  activation = NULL,
  input_shape = NULL,
  name = NULL,
  trainable = TRUE
)
}
\arguments{
\item{model}{A ggml_sequential_model object}

\item{units}{Number of output units}

\item{activation}{Activation function name: "relu", "sigmoid", "tanh", "softmax", or NULL}

\item{input_shape}{Integer or integer vector specifying the input shape (only needed for the first layer)}

\item{name}{Optional character name for the layer.}

\item{trainable}{Logical; whether the layer weights are updated during training.}
}
\value{
The model object with the dense layer appended (invisibly).
}
\description{
Add Dense (Fully Connected) Layer
}
\examples{
\donttest{
model <- ggml_model_sequential() |>
  ggml_layer_conv_2d(32, c(3,3), activation = "relu",
                     input_shape = c(28, 28, 1)) |>
  ggml_layer_flatten() |>
  ggml_layer_dense(128, activation = "relu")
}
}
