% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quants.R
\name{dequantize_row_mxfp4}
\alias{dequantize_row_mxfp4}
\title{Dequantize Row (MXFP4)}
\usage{
dequantize_row_mxfp4(raw_data, n_elements)
}
\arguments{
\item{raw_data}{Raw vector containing quantized data}

\item{n_elements}{Number of elements to dequantize}
}
\value{
Numeric vector of dequantized values
}
\description{
Converts MXFP4 (microscaling FP4) quantized data back to float values.
}
\seealso{
Other quantization: 
\code{\link{dequantize_row_iq2_xxs}()},
\code{\link{dequantize_row_q2_K}()},
\code{\link{dequantize_row_q4_0}()},
\code{\link{dequantize_row_tq1_0}()},
\code{\link{ggml_quant_block_info}()},
\code{\link{iq2xs_free_impl}()},
\code{\link{iq2xs_init_impl}()},
\code{\link{iq3xs_free_impl}()},
\code{\link{iq3xs_init_impl}()},
\code{\link{quantize_iq2_xxs}()},
\code{\link{quantize_mxfp4}()},
\code{\link{quantize_q2_K}()},
\code{\link{quantize_q4_0}()},
\code{\link{quantize_row_iq3_xxs_ref}()},
\code{\link{quantize_row_mxfp4_ref}()},
\code{\link{quantize_row_q2_K_ref}()},
\code{\link{quantize_row_q4_0_ref}()},
\code{\link{quantize_row_tq1_0_ref}()},
\code{\link{quantize_tq1_0}()}
}
\concept{quantization}
