% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ag_layers.R
\name{ag_embedding}
\alias{ag_embedding}
\title{Create an Embedding layer}
\usage{
ag_embedding(vocab_size, dim)
}
\arguments{
\item{vocab_size}{Vocabulary size}

\item{dim}{Embedding dimension}
}
\value{
An \code{ag_embedding} environment
}
\description{
Maps 0-based integer indices to dense vectors via table lookup.
Input: integer matrix or vector of 0-based indices.
Output: float tensor \code{[dim, length(idx)]}.
}
\details{
Backward: scatter-add — only the looked-up rows accumulate gradient.
}
\examples{
\donttest{
emb <- ag_embedding(100L, 16L)
idx <- c(0L, 3L, 7L, 2L)
out <- emb$forward(idx)   # [16, 4]
}
}
