% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_data_general.R
\name{process_data_general}
\alias{process_data_general}
\title{Process general/non-statistical data}
\usage{
process_data_general(data, from = "from", to = "to", group = NULL)
}
\arguments{
\item{data}{A DataFrame or tibble containing the input data to be processed.}

\item{from}{A string indicating the column name for the start nodes.}

\item{to}{A string indicating the column name for the end nodes.}

\item{group}{A string indicating the column name for the grouping variable.}
}
\value{
A DataFrame with the preprocessed data that is to be passed to gglyph::geom_glyph().
}
\description{
Prepare general/non-statistical data for plotting with gglyph::geom_glyph().
}
\examples{
data(sipri_milex_1995_2023)

# For non-grouped data
processed_data <- process_data_general(
  data = sipri_milex_1995_2023,
  from = "from",
  to = "to"
)

# For grouped data
processed_data <- process_data_general(
  data = sipri_milex_1995_2023,
  from = "from",
  to = "to",
  group = "group"
)
}
