% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-exceed.R
\docType{data}
\name{ScaleExceed}
\alias{ScaleExceed}
\alias{scale_fill_exceed}
\alias{scale_colour_exceed}
\title{Exceedance probability colour scales}
\format{
An object of class \code{ScaleExceed} (inherits from \code{ScaleContinuous}, \code{Scale}, \code{ggproto}, \code{gg}) of length 2.
}
\usage{
ScaleExceed

scale_fill_exceed(
  name = NULL,
  palette = "Oranges",
  type = "seq",
  direction = 1,
  dist_fun = NULL,
  threshold = 1.64,
  limits = c(0, 1),
  na.value = NA,
  guide = "colourbar",
  aesthetics = "fill",
  ...
)

scale_colour_exceed(
  name = NULL,
  palette = "Oranges",
  type = "seq",
  direction = 1,
  dist_fun = NULL,
  threshold = 1.64,
  limits = c(0, 1),
  na.value = NA,
  guide = "colourbar",
  aesthetics = "colour",
  ...
)
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{palette}{A palette function that when called with a numeric vector with
values between 0 and 1 returns the corresponding output values
(e.g., \code{\link[scales:pal_area]{scales::pal_area()}}).}

\item{type}{One of "seq" (sequential), "div" (diverging) or "qual"
(qualitative)}

\item{direction}{Sets the order of colours in the scale. If 1, the default,
colours are as output by \code{\link[RColorBrewer:ColorBrewer]{RColorBrewer::brewer.pal()}}. If -1, the
order of colours is reversed.}

\item{dist_fun}{A function used to compute the exceedance probability.
If \code{NULL} (the default), a normal distribution with \code{stats::pnorm()} is used.}

\item{threshold}{A numeric value specifying the threshold \code{q} in the exceedance
probability expression \code{P(X > q)}.}

\item{limits}{One of:
\itemize{
\item \code{NULL} to use the default scale range
\item A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum
\item A function that accepts the existing (automatic) limits and returns
new limits. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
Note that setting limits on positional scales will \strong{remove} data outside of the limits.
If the purpose is to zoom, use the limit argument in the coordinate system
(see \code{\link[ggplot2:coord_cartesian]{coord_cartesian()}}).
}}

\item{na.value}{Missing values will be replaced with this value.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}

\item{aesthetics}{The names of the aesthetics that this scale works with.}

\item{...}{Other arguments passed to \code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale()}}.}
}
\value{
A \code{ScaleExceed} ggproto object.
}
\description{
\verb{scale_*_exceed} computes exceedance probabilities from a specified
distribution and maps onto a continuous gradient colour scale.
}
\examples{
# Create an exceedance probability scale
sc <- scale_fill_exceed()
class(sc)

# Basic bivariate map
p <- ggplot(nc) + geom_sf(aes(fill = duo_exceed(value, sd)))

}
\keyword{datasets}
