% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend_style.R
\name{legend_style}
\alias{legend_style}
\title{Style Legend Appearance}
\usage{
legend_style(
  size = NULL,
  family = NULL,
  face = NULL,
  color = NULL,
  angle = NULL,
  title_size = NULL,
  title_face = NULL,
  title_color = NULL,
  title_angle = NULL,
  title_hjust = NULL,
  title_vjust = NULL,
  title_position = NULL,
  key_width = NULL,
  key_height = NULL,
  key_fill = NULL,
  spacing = NULL,
  spacing_x = NULL,
  spacing_y = NULL,
  margin = NULL,
  background = NULL,
  background_color = NULL,
  box_background = NULL,
  box_margin = NULL,
  direction = NULL,
  byrow = NULL,
  by = NULL
)
}
\arguments{
\item{size}{Text size for legend labels (in points).}

\item{family}{Font family for legend text.}

\item{face}{Font face for legend text (\code{"plain"}, \code{"bold"},
\code{"italic"}, \code{"bold.italic"}).}

\item{color}{Text color for legend labels.}

\item{angle}{Rotation angle for legend labels (in degrees). Supported values:
45, -45, 90, -90. Text justification is set automatically for optimal
alignment with legend keys.}

\item{title_size}{Text size for legend title (in points). If \code{NULL},
inherits from \code{size}.}

\item{title_face}{Font face for legend title. If \code{NULL}, inherits from
\code{face}.}

\item{title_color}{Text color for legend title. If \code{NULL}, inherits from
\code{color}.}

\item{title_angle}{Rotation angle for legend title (in degrees).}

\item{title_hjust}{Horizontal justification for rotated title.}

\item{title_vjust}{Vertical justification for rotated title.}

\item{title_position}{Position of legend title relative to keys. One of
\code{"top"}, \code{"bottom"}, \code{"left"}, \code{"right"}.}

\item{key_width}{Width of legend keys. Numeric (in cm) or a \code{unit} object.}

\item{key_height}{Height of legend keys. Numeric (in cm) or a \code{unit} object.}

\item{key_fill}{Background fill color for legend keys.}

\item{spacing}{Spacing between legend entries. Numeric (in cm) or a \code{unit}
object.}

\item{spacing_x}{Horizontal spacing between legend entries.}

\item{spacing_y}{Vertical spacing between legend entries.}

\item{margin}{Margin around entire legend. Single value (all sides) or vector
of 4 values (top, right, bottom, left) in cm.}

\item{background}{Legend background fill color. Use \code{NA} for transparent.}

\item{background_color}{Legend background border color. Use \code{NA} for no
border.}

\item{box_background}{Background fill for the box containing multiple legends.
Ignored when \code{by} is specified.}

\item{box_margin}{Margin around the legend box. Single value or 4-vector in cm.
Ignored when \code{by} is specified.}

\item{direction}{Legend direction: \code{"horizontal"} or \code{"vertical"}.}

\item{byrow}{For multi-column legends, fill by row (\code{TRUE}) or by column
(\code{FALSE}).}

\item{by}{Optional aesthetic name (character) to style only a specific legend.
When specified, uses per-guide theming via \code{guide_legend(theme = ...)}.
Requires ggplot2 >= 3.5.0. Common values: \code{"colour"}, \code{"fill"},
\code{"size"}.}
}
\value{
A ggplot2 theme object (when \code{by} is NULL) or a guides
specification (when \code{by} is specified).
}
\description{
A comprehensive one-liner to style all legend elements consistently. Instead
of setting multiple theme elements separately, use this function to control
text, title, keys, spacing, background, and direction in one call.
}
\examples{
library(ggplot2)

# Simple: consistent font
ggplot(mtcars, aes(mpg, wt, color = factor(cyl))) +
  geom_point() +
  legend_style(size = 12, family = "serif")

# Styled title and keys
ggplot(mtcars, aes(mpg, wt, color = factor(cyl))) +
  geom_point() +
  legend_style(
    size = 10,
    title_size = 14,
    title_face = "bold",
    key_width = 1.5
  )

# Full styling with background
ggplot(mtcars, aes(mpg, wt, color = factor(cyl))) +
  geom_point() +
  legend_style(
    size = 11,
    title_size = 13,
    title_face = "bold",
    key_fill = "grey95",
    background = "white",
    background_color = "grey80",
    margin = 0.3
  )

# Rotated labels for long category names
ggplot(mpg, aes(displ, hwy, color = class)) +
  geom_point() +
  legend_style(angle = 45)

# Style only the colour legend
ggplot(mtcars, aes(mpg, wt, color = factor(cyl), size = hp)) +
  geom_point() +
  legend_style(title_face = "bold", background = "grey95", by = "colour") +
  legend_style(size = 10, by = "size")

}
\seealso{
\code{\link{legend_left}}, \code{\link{legend_wrap}},
\code{\link{legend_reverse}}
}
