% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend_multi.R
\name{legend_hide}
\alias{legend_hide}
\title{Hide Specific Legends}
\usage{
legend_hide(...)
}
\arguments{
\item{...}{Aesthetic names (unquoted) to hide. Common values: \code{colour},
\code{fill}, \code{size}, \code{shape}, \code{linetype}, \code{alpha}.
Note: \code{color} is automatically converted to \code{colour}.}
}
\value{
A guides specification that can be added to a plot.
}
\description{
Remove specific legends from a plot while keeping others. This is more
targeted than \code{legend_none()} which removes all legends.
}
\examples{
library(ggplot2)

# Plot with multiple legends
p <- ggplot(mtcars, aes(mpg, wt, color = factor(cyl), size = hp)) +
  geom_point()

# Hide the size legend
p + legend_hide(size)

# Hide multiple legends
p + legend_hide(size, colour)

}
\seealso{
\code{\link{legend_select}}, \code{\link{legend_none}}
}
