% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inner_glow.R
\name{with_inner_glow}
\alias{with_inner_glow}
\title{Apply an inner glow to your layer}
\usage{
with_inner_glow(x, colour = "black", sigma = 3, expand = 0, ...)
}
\arguments{
\item{x}{A ggplot2 layer object, a ggplot, a grob, or a character string
naming a filter}

\item{colour}{The colour of the glow}

\item{sigma}{The standard deviation of the gaussian kernel. Increase it to
apply more blurring. If a numeric it will be interpreted as given in pixels.
If a unit object it will automatically be converted to pixels at rendering
time}

\item{expand}{An added dilation to the glow mask before blurring it}

\item{...}{Arguments to be passed on to methods. See
\link[=object_support]{the documentation of supported object} for a description of
object specific arguments.}
}
\value{
Depending on the input, either a \code{grob}, \code{Layer}, list of \code{Layer}s,
\code{guide}, or \code{element} object. Assume the output can be used in the same
context as the input.
}
\description{
This filter adds an inner glow to your layer with a specific colour and size.
The best effect is often had by drawing the stroke separately so the glow is
only applied to the fill.
}
\examples{
library(ggplot2)

ggplot(mtcars, aes(as.factor(gear), disp)) +
  with_inner_glow(
    geom_boxplot(),
    colour = 'red',
    sigma = 10
  )

# This gives a red tone to the lines as well which may not be desirable
# This can be fixed by drawing fill and stroke separately
ggplot(mtcars, aes(as.factor(gear), disp)) +
  with_inner_glow(
    geom_boxplot(colour = NA),
    colour = 'red',
    sigma = 10
  ) +
  geom_boxplot(fill = NA)

}
\seealso{
Other glow filters: 
\code{\link{with_outer_glow}()}
}
\concept{glow filters}
