% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angle_correction.r
\name{angle_correction}
\alias{angle_correction}
\title{Calculate correction for angle in the plot coordinate system}
\usage{
angle_correction(data, panel_params, coord)
}
\arguments{
\item{data}{fortified data used in a \code{\link[=geom_fields]{geom_fields()}}. Should at least contain \code{numeric} columns \code{x}, \code{y} and
\code{angle}.}

\item{panel_params}{panel parameters as returned by \link[=GeomFields]{GeomFields$setup_params()}}

\item{coord}{A \link[ggplot2:coord_cartesian]{coord} object.}
}
\value{
A \code{data.frame} with an additional \code{angle_correction} column. The corrected angle is given
by \code{angle_correction + angle}.
}
\description{
The angle of a vector may be distorted when your plot uses a different
coordinate system than the one for which the angle is specified. If \code{data}
is a simple feature object (\link[sf:sf]{sf}), the angle will be corrected
for the displayed coordinate reference system (\link[sf:st_crs]{crs}). When
the crs is missing, an aspect ratio of 1 is assumed. For any other data,
the angle is corrected for the aspect ratio in the plot.
}
\details{
This function is used by default by \code{\link[=geom_fields]{geom_fields()}}. For more details on
why this correction is required and how to customize corrections please see
\code{vignette("angle_correction")}.
}
\examples{
if (requireNamespace("ggplot2") && requireNamespace("stars")) {
  library(ggplot2)
  library(stars)

  ggplot() +
    geom_fields(
      data    = seawatervelocity,
      mapping = aes(radius = as.numeric(v),
                    angle  = as.numeric(angle),
                    col    = as.numeric(v)),
 ## You can provide the `angle_correction()` as argument explicitly
 ## (it is already the default). Note that the plotted region requires
 ## hardly any correction for the angles.
                .angle_correction = angle_correction)
}
}
\author{
Pepijn de Vries
}
