% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend.R
\name{easy_remove_legend}
\alias{easy_remove_legend}
\title{Easily remove legend(s)}
\usage{
easy_remove_legend(..., teach = FALSE)
}
\arguments{
\item{...}{optional name(s) specific aesthetics for which to remove the
legend}

\item{teach}{print longer equivalent \code{\link[ggplot2]{ggplot2}}
expression?}
}
\value{
either a \code{\link[ggplot2]{theme}} object or a
\code{\link[ggplot2]{guides}}object, both of which can be used in
\code{\link[ggplot2]{ggplot2}} calls
}
\description{
With no argument, will remove all legends. Provide the name(s) of
specific aesthetic to remove only certain legends.
}
\examples{

library(ggplot2)

# Remove all legends
ggplot(mtcars, aes(wt, mpg, colour = cyl, size = hp)) +
  geom_point() + easy_remove_legend()

# remove just size legend
ggplot(mtcars, aes(wt, mpg, colour = cyl, size = hp)) +
  geom_point() + easy_remove_legend("size")

# can also use:
ggplot(mtcars, aes(wt, mpg, colour = cyl, size = hp)) +
  geom_point() + easy_remove_legend(size)

# Remove more than one
ggplot(mtcars, aes(wt, mpg, colour = cyl, size = hp)) +
  geom_point() + easy_remove_legend(size, color)
}
\author{
Alicia Schep
}
