% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{split_parameter_x_condition}
\alias{split_parameter_x_condition}
\alias{bind_condition2parameters_r}
\title{Map Experimental Conditions to Model Parameters}
\usage{
split_parameter_x_condition(parameter_M_r)

bind_condition2parameters_r(parameter_map_r, factors_r)
}
\arguments{
\item{parameter_M_r}{a string vector of parameter x condition.}

\item{parameter_map_r}{A named list received from R (converted to
Rcpp::List) where:
\itemize{
  \item Names correspond to parameter names
  \item Elements are character vectors mapping conditions to parameter
}}

\item{factors_r}{A named list of experimental factors where:
\itemize{
  \item Names are factor names
  \item Elements are character vectors of factor levels
}}
}
\value{
A character vector where each element represents a
parameter-condition binding in the format 'parameter.condition'.
The special 'M' factor is to represent matching and non-matching
true/false in the LBA model.
}
\description{
Binds experimental conditions to model parameters by combining parameter
mappings and experimental factors, automatically handling the 'M' (
matching) factor, specifically for the Linear Ballisitic Accumulation Model.
\code{split_parameter_x_condition} separates bound parameters and conditions.
}
\details{
This function:
\enumerate{
  \item Converts R lists to C++ std::map containers for efficient lookup
  \item Processes the parameter mapping through `add_M()` to handle response
mappings
  \item Returns human-readable parameter-condition pairs  
}
}
\section{C++ Implementation}{

The function uses:
\itemize{
  \item Rcpp::List to take the 'list' from R and convert it to C++
std::map for efficient key-value lookups
  \item std::vector for storing the resulting parameter-condition pairs
  \item Rcpp::CharacterVector for returning the result to R
}
}

\examples{
p_map <- list(A = "1", B = "1", t0 = "1", mean_v = c("M", "S"), sd_v = "1",
          st0 = "1")
factors <- list(S = c("s1", "s2"))
parameter_M <-bind_condition2parameters_r(p_map, factors)
# [1] "A"               "B"               "mean_v.s1.false" "mean_v.s1.true"
# [5] "mean_v.s2.false" "mean_v.s2.true"  "sd_v"            "st0"
# [9] "t0"

result <- split_parameter_x_condition(parameter_M)
# [[1]]
# [1] "A"
#
# [[2]]
# [1] "B"
#
# [[3]]
# [1] "mean_v" "s1"     "false"
#
# [[4]]
# [1] "mean_v" "s1"     "true"
#
# [[5]]
# [1] "mean_v" "s2"     "false"
#
# [[6]]
# [1] "mean_v" "s2"     "true"
#
# [[7]]
# [1] "sd_v"
#
# [[8]]
# [1] "st0"
#
# [[9]]
# [1] "t0"
}
