% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_ecdf.R
\name{weighted_ecdf}
\alias{weighted_ecdf}
\title{Weighted empirical cumulative distribution function}
\usage{
weighted_ecdf(x, weights = NULL, na.rm = FALSE)
}
\arguments{
\item{x}{<\link{numeric}> Sample values.}

\item{weights}{<\link{numeric} | \link{NULL}> Weights for the sample. One of:
\itemize{
\item numeric vector of same length as \code{x}: weights for corresponding values in \code{x},
which will be normalized to sum to 1.
\item \code{NULL}: indicates no weights are provided, so the unweighted empirical
cumulative distribution function (equivalent to \code{\link[=ecdf]{ecdf()}}) is returned.
}}

\item{na.rm}{<scalar \link{logical}> If \code{TRUE}, corresponding entries in \code{x} and \code{weights}
are removed if either is \code{NA}.}
}
\value{
\code{weighted_ecdf()} returns a function of class \code{"weighted_ecdf"}, which also
inherits from the \code{\link[=stepfun]{stepfun()}} class. Thus, it also has \code{plot()} and \code{print()}
methods. Like \code{\link[=ecdf]{ecdf()}}, \code{\link[=weighted_ecdf]{weighted_ecdf()}} also provides a \code{\link[=quantile]{quantile()}} method,
which dispatches to \code{\link[=weighted_quantile]{weighted_quantile()}}.
}
\description{
A variation of \code{\link[=ecdf]{ecdf()}} that can be applied to weighted samples.
}
\details{
Generates a weighted empirical cumulative distribution function, \eqn{F(x)}.
Given \eqn{x}, a sorted vector (derived from \code{x}), and \eqn{w_i}, the corresponding
\code{weight} for \eqn{x_i}, \eqn{F(x)} is a step function with steps at each \eqn{x_i}
with \eqn{F(x_i)} equal to the sum of all weights up to and including \eqn{w_i}.
}
\examples{
weighted_ecdf(1:3, weights = 1:3)
plot(weighted_ecdf(1:3, weights = 1:3))
quantile(weighted_ecdf(1:3, weights = 1:3), 0.4)
}
\seealso{
\code{\link[=weighted_quantile]{weighted_quantile()}}
}
