% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subscale.R
\name{subscale_thickness}
\alias{subscale_thickness}
\title{Sub-scale for thickness aesthetic}
\usage{
subscale_thickness(
  x,
  limits = function(l) c(min(0, l[1]), l[2]),
  expand = c(0, 0)
)
}
\arguments{
\item{x}{<\link{numeric}> Vector to be rescaled.
Typically provided automatically by \code{\link[=geom_slabinterval]{geom_slabinterval()}}.}

\item{limits}{<length-2 \link{numeric} | \link{function} | \link{NULL}> One of:
\itemize{
\item A \link{numeric} vector of length two providing the limits of the scale. Use
\code{NA} to use the default minimum or maximum.
\item A function that accepts a length-2 \link{numeric} vector of the automatic
limits and returns new limits. Unlike positional scales, these limits
will not remove data.
\item \code{NULL} to use the range of the data
}}

\item{expand}{<\link{numeric}> Vector of limit expansion constants of length
2 or 4, following the same format used by the \code{expand} argument of
\code{\link[ggplot2:continuous_scale]{continuous_scale()}}. The default is not to expand the limits.
You can use the convenience function \code{\link[ggplot2:expansion]{expansion()}} to generate the
expansion values; expanding the lower limit is usually not recommended
(because with most \code{thickness} scales the lower limit is the baseline
and represents \code{0}), so a typical usage might be something like
\code{expand = expansion(c(0, 0.05))} to expand the top end of the scale
by 5\%.}
}
\value{
A \link{thickness} vector of the same length as \code{x} scaled to be between
\code{0} and \code{1}.
}
\description{
This is a sub-scale intended for adjusting the scaling of the \code{thickness}
aesthetic at a geometry (or sub-geometry) level in \pkg{ggdist}. It can be
used with the \code{subscale} parameter of \code{\link[=geom_slabinterval]{geom_slabinterval()}}.

Supports \link[=auto_partial]{automatic partial function application} with
\link[=waiver]{waived arguments}.
}
\details{
You can overwrite \code{subscale_thickness} in the global environment to set
the default properties of the thickness subscale. For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{subscale_thickness = ggdist::subscale_thickness(expand = expansion(c(0, 0.05)))
}\if{html}{\out{</div>}}

This will cause \code{\link[=geom_slabinterval]{geom_slabinterval()}}s to default to a thickness subscale
that expands by 5\% at the top of the scale. \strong{Always} prefix such a
definition with \verb{ggdist::} to avoid infinite loops caused by recursion.
}
\examples{
library(ggplot2)
library(distributional)

df = data.frame(d = dist_normal(2:3, 1), g = c("a", "b"))

# breaks on thickness subguides are always limited to the bounds of the
# subscale, which may leave labels off near the edge of the subscale
# (e.g. here `0.4` is omitted because the max value is approx `0.39`)
ggplot(df, aes(xdist = d, y = g)) +
  stat_slabinterval(
    subguide = "inside"
  )

# We can use the subscale to expand the upper limit of the thickness scale
# by 5\% (similar to the default for positional scales), allowing bounds near
# (but just less than) the limit, like `0.4`, to be shown.
ggplot(df, aes(xdist = d, y = g)) +
  stat_slabinterval(
    subguide = "inside",
    subscale = subscale_thickness(expand = expansion(c(0, 0.5)))
  )
}
\seealso{
The \link{thickness} datatype.

The \code{thickness} aesthetic of \code{\link[=geom_slabinterval]{geom_slabinterval()}}.

\code{\link[=scale_thickness_shared]{scale_thickness_shared()}}, for setting a \code{thickness} scale across
all geometries using the \code{thickness} aesthetic.

Other sub-scales: 
\code{\link{subscale_identity}()}
}
\concept{sub-scales}
