% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bezier.R
\name{ob_bezier}
\alias{ob_bezier}
\title{The ob_bezier (i.e., bezier curve) class}
\usage{
ob_bezier(
  p = S7::class_missing,
  label = character(0),
  label_sloped = TRUE,
  n = 100,
  alpha = numeric(0),
  arrow_head = S7::class_missing,
  arrow_fins = S7::class_missing,
  arrowhead_length = numeric(0),
  length_head = numeric(0),
  length_fins = numeric(0),
  color = character(0),
  fill = character(0),
  lineend = numeric(0),
  linejoin = numeric(0),
  linewidth = numeric(0),
  linewidth_fins = numeric(0),
  linewidth_head = numeric(0),
  linetype = numeric(0),
  resect = numeric(0),
  resect_fins = numeric(0),
  resect_head = numeric(0),
  stroke_color = character(0),
  stroke_width = numeric(0),
  style = S7::class_missing,
  id = character(0),
  ...
)
}
\arguments{
\item{p}{ob_point or list of ob_points}

\item{label}{A character, angle, or label object}

\item{label_sloped}{A logical value indicating whether the label should be sloped with the curve}

\item{n}{Number of points in a polygon, circle, arc, or ellipse}

\item{alpha}{numeric value for alpha transparency}

\item{arrow_head}{A 2-column matrix of polygon points}

\item{arrow_fins}{A 2-column matrix of polygon points}

\item{arrowhead_length}{Determines the size of the arrow ornaments. This parameter becomes the \code{length} parameter in ggarrow functions. Numeric values set the ornament size relative to the linewidth. A \link[grid:unit]{grid::unit} value sets the ornament size in an absolute manner.}

\item{length_head}{Determines the size of the arrow head. Numeric values set the ornament size relative to the linewidth. A \link[grid:unit]{grid::unit} value sets the ornament size in an absolute manner. From ggarrow.}

\item{length_fins}{Determines the size of the arrow fins. Numeric values set the ornament size relative to the linewidth. A \link[grid:unit]{grid::unit} value sets the ornament size in an absolute manner. From ggarrow.}

\item{color}{character string for color}

\item{fill}{character string for fill color}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{linewidth}{Width of lines}

\item{linewidth_fins}{Line width for arrow fins}

\item{linewidth_head}{Line width for arrow fins}

\item{linetype}{type of lines}

\item{resect}{A numeric(1) denoting millimeters or \link[grid:unit]{grid::unit} to shorten the arrow head and fins.}

\item{resect_fins}{A numeric(1) denoting millimeters or \link[grid:unit]{grid::unit} to shorten the arrow fins}

\item{resect_head}{A numeric(1) denoting millimeters or \link[grid:unit]{grid::unit} to shorten the arrow head.}

\item{stroke_color}{Color of point border line}

\item{stroke_width}{Stroke width in arrows}

\item{style}{Gets and sets the styles associated with ob_beziers}

\item{id}{character string to identify object}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}>  properties passed to style}
}
\value{
ob_bezier object
}
\description{
The ob_bezier is specified with an ob_point object that contains at least 2 points, the start and the end. Such a "curve" would actually be a straight line segment. If three points are specified, the middle point is a control point, and a quadratic bezier curve will result. Higher-order bezier curves can be created by having more control points in the middle.
}
\details{
If you wish to specify multiple bezier curves, you must supply a list of ob_point objects. When plotted, the ob_bezier function uses the bezier::bezier function to create the point coordinates of the curve and the ggarrow::geom_arrow function to create the geom.
}
\section{Slots}{

\describe{
\item{\code{length}}{The number of curves in the ob_bezier object}

\item{\code{tibble}}{Gets a tibble (data.frame) containing parameters and styles used by \code{ggarrow::geom_arrow}.}

\item{\code{geom}}{A function that converts the object to a geom. Any additional parameters are passed to \code{ggarrow::geom_arrow}.}

\item{\code{midpoint}}{A function that selects 1 or more midpoints of the ob_bezier. The \code{position} argument can be between 0 and 1. Additional arguments are passed to \code{ob_point}.}

\item{\code{aesthetics}}{A list of information about the ob_bezier's aesthetic properties}
}}

\examples{
control_points <- ob_point(c(0,1,2,4), c(0,4,0,0))
ggdiagram() +
  ob_bezier(control_points, color = "blue")
}
