% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grob_arrow_path.R
\name{grob_arrow}
\alias{grob_arrow}
\title{Arrow grob}
\usage{
grob_arrow(
  x = unit(c(0, 1), "npc"),
  y = unit(c(0, 1), "npc"),
  id = NULL,
  id.lengths = NULL,
  arrow_head = arrow_head_wings(),
  arrow_fins = NULL,
  arrow_mid = NULL,
  length_head = unit(5, "mm"),
  length_fins = NULL,
  length_mid = NULL,
  justify = 0,
  shaft_width = unit(1, "mm"),
  mid_place = 0.5,
  resect = unit(0, "mm"),
  resect_fins = NULL,
  resect_head = NULL,
  force_arrow = FALSE,
  default.units = "mm",
  name = NULL,
  gp = gpar(),
  vp = NULL
)
}
\arguments{
\item{x}{A numeric vector or unit object specifying x-values.}

\item{y}{A numeric vector or unit object specifying y-values.}

\item{id}{A numeric vector used to separate locations in \code{x} and
    \code{y} into multiple lines.  All locations with the same
    \code{id} belong to the same line.}

\item{id.lengths}{A numeric vector used to separate locations in \code{x} and
    \code{y} into multiple lines.  Specifies consecutive blocks of
    locations which make up separate lines.}

\item{arrow_head, arrow_fins, arrow_mid}{A \verb{<matrix[n, 2]>}, such as those
returned by \link[=arrow_ornaments]{arrow ornament} functions, giving arrow
shapes. The matrix can (should) have the \code{notch_angle} attribute that will
be used to fuse the shaft to the arrow ornaments. If \code{NULL}, no ornament
will be drawn.}

\item{length_head, length_fins, length_mid}{A \code{\link[grid:unit]{<unit>}} object
controlling the size of the arrow ornaments.}

\item{justify}{A \code{numeric(1)} between [0-1] to control where the
arrows should be drawn relative to the path's endpoints. A value of \code{0}
sets the arrow's tips at the path's end, whereas a value of \code{1} sets the
arrow's base at the path's end.}

\item{shaft_width}{A \code{\link[grid:unit]{<unit>}} object controlling the width
of the arrow's shaft.}

\item{mid_place}{Sets the location of middle (interior) arrows, when
applicable. Can be one of the following:
\describe{
\item{A \code{numeric} vector}{with values between [0-1] to set middle
arrows at relative positions along the arc-length of a path.}
\item{A \code{<}\code{\link[grid:unit]{unit}}\code{>}}{to fill a path with arrows with
the provided unit as distance between one arrow to the next.}
}}

\item{resect, resect_fins, resect_head}{A \code{\link[grid:unit]{<unit>}} object that
can be used to create an offset between the endings of the coordinates
and where the arrow will be displayed visually. \code{resect_fins} and
\code{resect_head} control this offset at the start and end of the arrow
respectively and both default to \code{resect}.}

\item{force_arrow}{A \code{logical(1)} which, if \code{TRUE} an arrow will be drawn
even when the length of the arrow is shorter than the arrow heads and fins.
If \code{FALSE}, will drop such arrows.}

\item{default.units}{A string indicating the default units to use
    if \code{x} or \code{y} are only given as numeric vectors.}

\item{name}{ A character identifier. }

\item{gp}{An object of class \code{"gpar"}, typically the output
    from a call to the function \code{\link[grid]{gpar}}.  This is basically
    a list of graphical parameter settings.}

\item{vp}{A Grid viewport object (or NULL).}
}
\value{
A \verb{<arrow_path>} \link[grid:grid.grob]{graphical object}.
}
\description{
Creates a graphical object that draws arrows. An arrow typically consists of
three parts: the arrowhead, the shaft and fins. Relative to how an arrow
is drawn from coordinates, these three parts describe the end, middle and
beginning of an arrow line.
}
\examples{
requireNamespace("grid")

# Creating an arrow
arrow <- grob_arrow(
  x = unit(c(0.2, 0.5, 0.8, 0.2, 0.5, 0.8), "npc"),
  y = unit(c(0.2, 0.8, 0.2, 0.8, 0.2, 0.8), "npc"),
  id.lengths  = c(3, 3),
  arrow_head  = arrow_head_wings(),
  arrow_fins  = arrow_fins_feather(),
  length_fins = 8,
  shaft_width = 1,
  gp = grid::gpar(fill = c("dodgerblue", "tomato"), col = "black")
)

# Drawing the arrow
grid::grid.newpage(); grid::grid.draw(arrow)
}
