% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-stratum.r
\name{geom_stratum}
\alias{geom_stratum}
\title{Strata at axes}
\usage{
geom_stratum(
  mapping = NULL,
  data = NULL,
  stat = "stratum",
  position = "identity",
  show.legend = NA,
  inherit.aes = TRUE,
  width = 1/3,
  na.rm = FALSE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data;
override the default.}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{width}{Numeric; the width of each stratum, as a proportion of the
distance between axes. Defaults to 1/3.}

\item{na.rm}{Logical:
if \code{FALSE}, the default, \code{NA} lodes are not included;
if \code{TRUE}, \code{NA} lodes constitute a separate category,
plotted in grey (regardless of the color scheme).}

\item{...}{Additional arguments passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.}
}
\description{
\code{geom_stratum} receives a dataset of the horizontal (\code{x}) and vertical (\code{y},
\code{ymin}, \code{ymax}) positions of the strata of an alluvial plot. It plots
rectangles for these strata of a provided \code{width}.
}
\section{Aesthetics}{

\code{geom_alluvium}, \code{geom_flow}, \code{geom_lode}, and \code{geom_stratum} understand the
following aesthetics (required aesthetics are in bold):
\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \strong{\code{ymin}}
\item \strong{\code{ymax}}
\item \code{alpha}
\item \code{colour}
\item \code{fill}
\item \code{linetype}
\item \code{size}
\item \code{group}
}

\code{group} is used internally; arguments are ignored.

Alluvium, flow, and lode geoms default to \code{alpha = 0.5}. Learn more about
setting these aesthetics in \code{vignette("ggplot2-specs", package = "ggplot2")}.
}

\section{Defunct parameters}{

The previously defunct parameters \code{axis_width} and \code{ribbon_bend} have been
discontinued. Use \code{width} and \code{knot.pos} instead.
}

\examples{
# full axis width
ggplot(as.data.frame(Titanic),
       aes(y = Freq,
           axis1 = Class, axis2 = Sex, axis3 = Age, axis4 = Survived)) +
  geom_stratum(width = 1) +
  geom_text(stat = "stratum", aes(label = after_stat(stratum))) +
  scale_x_discrete(limits = c("Class", "Sex", "Age", "Survived"))
  
# use of facets
ggplot(as.data.frame(Titanic),
       aes(y = Freq,
           axis1 = Class, axis2 = Sex)) +
  geom_flow(aes(fill = Survived)) +
  geom_stratum() +
  geom_text(stat = "stratum", aes(label = after_stat(stratum))) +
  scale_x_discrete(limits = c("Class", "Sex")) +
  facet_wrap(~ Age, scales = "free_y")
}
\seealso{
\code{\link[ggplot2:layer]{ggplot2::layer()}} for additional arguments and
\code{\link[=stat_stratum]{stat_stratum()}} for the corresponding stat.

Other alluvial geom layers: 
\code{\link{geom_alluvium}()},
\code{\link{geom_flow}()},
\code{\link{geom_lode}()}
}
\concept{alluvial geom layers}
