% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms.R
\name{\%of\%}
\alias{\%of\%}
\title{Composition of scale transforms.}
\usage{
atrans \%of\% btrans
}
\arguments{
\item{atrans}{a transformation object.}

\item{btrans}{a transformation object.}
}
\value{
a transformation object that perfroms \code{atrans} on the output of \code{btrans}.
}
\description{
A binary infix operator that allows one to compose together two
scale transformations. We should have that the transformation
\code{atrans \%of\% btrans} first applies \code{btrans}, then
applies \code{atrans} to the results. This is useful for
reversing scales, for example, along with other transformations.
}
\examples{
set.seed(1234)
# compose transformatins with \%of\%:
ggplot(data.frame(x=rnorm(100),y=exp(rnorm(100,mean=-2,sd=4))),aes(x=x,y=y)) + 
  geom_point() + 
  scale_y_continuous(trans=scales::reverse_trans() \%of\% scales::log10_trans())

}
\seealso{
\code{\link[scales]{trans_new}}.
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{plotting}
