% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/break_uncertainty.R
\name{break_uncertainty}
\alias{break_uncertainty}
\title{Estimate Breakdate Uncertainty}
\usage{
break_uncertainty(x, m = 15, interval = 0.99)
}
\arguments{
\item{x}{An object produced by the isatpanel function}

\item{m}{Maximum range of interval (default is 15 time periods).}

\item{interval}{Approximate level of interval. CI level will be at least > interval. Default 0.99 is a 99\% CI, so the time interval will always be the integer that results in at least > 99\% coverage.}
}
\value{
A data.frame that indicates the uncertainty for each FESIS break. The time interval is given by the estimated date in the 'time' column with a confidence interval of +/- the interval in the tci column.
}
\description{
Estimate Breakdate Uncertainty
}
\examples{
\donttest{
data(EU_emissions_road)

# Group specification
EU15 <- c("Austria", "Germany", "Denmark", "Spain", "Finland", "Belgium",
         "France", "United Kingdom", "Ireland", "Italy", "Luxembourg",
         "Netherlands", "Greece", "Portugal", "Sweden")

# Prepare sample and data
EU_emissions_road_short <- EU_emissions_road[
EU_emissions_road$country \%in\% EU15 &
EU_emissions_road$year >= 2000,
]

# Run
result <- isatpanel(
  data = EU_emissions_road_short,
  formula = ltransport.emissions ~ lgdp + I(lgdp^2) + lpop,
  index = c("country", "year"),
  effect = "twoways",
  fesis = TRUE,
  plot = FALSE,
  t.pval = 0.01
)

break_uncertainty(result)
}
}
