% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05-mosaicing.R
\name{select_rasters_for_region}
\alias{select_rasters_for_region}
\title{Select rasters for specific region with intelligent filtering}
\usage{
select_rasters_for_region(input_folder, region_boundary, buffer_size = 0.1)
}
\arguments{
\item{input_folder}{Directory containing raster files}

\item{region_boundary}{Region boundary or bounding box}

\item{buffer_size}{Buffer around region (in degrees)}
}
\value{
Character vector of relevant file paths
}
\description{
Intelligently select raster files that overlap with a specified region.
}
\examples{
\donttest{
# Select ASTER files for Michigan
michigan_files <- select_rasters_for_region("/aster/files", "Michigan")

# Select with custom buffer
nevada_files <- select_rasters_for_region("/data", "Nevada", buffer_size = 0.2)
}

}
