% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nuts.R
\name{get_nuts}
\alias{get_nuts}
\title{Identify NUTS Regions for Geolocations}
\usage{
get_nuts(
  latitude,
  longitude,
  level = "all",
  year = 2021,
  resolution = 20,
  crs = 4326,
  country = NULL,
  match_strategy = c("within", "nearest"),
  nearest_max_km = Inf,
  verbose = TRUE
)
}
\arguments{
\item{latitude}{(numeric, \strong{mandatory}) Latitudes in decimal degrees (WGS84).
Must be within \code{[-90, 90]}.}

\item{longitude}{(numeric, \strong{mandatory}) Longitudes in decimal degrees (WGS84).
Must be within \code{[-180, 180]}. Length must match \code{latitude}.}

\item{level}{(integer or character, optional) One of \code{0, 1, 2, 3, "all"}.
Default: \code{"all"}. When \code{"all"}, the result includes \code{nuts0..nuts3}.}

\item{year}{(integer, optional) NUTS reference year for the Eurostat layer.
Default: \code{2021}.}

\item{resolution}{(integer, optional) Eurostat map resolution. Typical
values: \code{1, 3, 10, 20, 60}. Default: \code{20}.}

\item{crs}{(integer, optional) EPSG code of input coordinates. If not 4326,
inputs are transformed to WGS84 (EPSG:4326). Default: \code{4326}.}

\item{country}{(character, optional) Two-letter \code{CNTR_CODE} to pre-filter
polygons (e.g., \code{"DE"}, \code{"IT"}). Reduces memory and speeds up queries.}

\item{match_strategy}{(character, optional) Matching strategy:
\code{"within"} (default) assigns a NUTS only when the point lies within a
polygon; \code{"nearest"} uses the nearest NUTS polygon for unmatched points.}

\item{nearest_max_km}{(numeric, optional) Maximum distance (km) for
nearest fallback; use \code{Inf} to allow any distance. Default: \code{Inf}.}

\item{verbose}{(logical, optional) Print informative messages. Default: \code{TRUE}.}
}
\value{
If \code{level} is a single integer: a \code{data.frame} with columns
\code{lat, lon, nuts, cntr_code, match_status, match_dist_km, level, year, resolution}.
If \code{level = "all"}: a \code{data.frame} with
\code{lat, lon, nuts0, nuts1, nuts2, nuts3, cntr_code, match_status, match_dist_km, year, resolution}.
Here \code{match_status}/\code{match_dist_km} are computed using level 3 (most granular).
}
\description{
Vectorised identification of NUTS regions for input coordinates using
Eurostat geospatial layers. Supports a single level (0–3) or \code{"all"} to
return all levels. Optional country pre-filter and "nearest" fallback make
the function robust to points falling just outside polygon boundaries.
}
\details{
\itemize{
\item Geometries are downloaded via \code{eurostat::get_eurostat_geospatial()} and
cached per \code{(level, year, resolution)} to avoid repeated I/O.
\item Polygons are pre-filtered using the points' bounding box to accelerate
joins on continental layers (with safe fallback).
\item Nearest distances are computed with units and converted to kilometers.
}
}
\examples{
\donttest{
  res <- get_nuts(52.52, 13.405, level = 3, year = 2021, resolution = 20)
  head(res)
}
}
\seealso{
\code{\link{map_nuts}}
}
