% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOMetadata.R
\docType{class}
\name{ISOMetadata}
\alias{ISOMetadata}
\title{ISOMetadata}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an ISO Metadata
}
\description{
ISOMetadata

ISOMetadata
}
\examples{
    #example 1 - WRITE: Create an ISO metadata and encode it as XML
    #######################################################
    md = ISOMetadata$new()
    md$setFileIdentifier("my-metadata-identifier")
    md$setParentIdentifier("my-parent-metadata-identifier")
    md$setCharacterSet("utf8")
    md$setLanguage("eng")
    md$setDateStamp(ISOdate(2015, 1, 1, 1))
    md$setMetadataStandardName("ISO 19115:2003/19139")
    md$setMetadataStandardVersion("1.0")
    md$setDataSetURI("my-dataset-identifier")
    
    #add 3 contacts
    for(i in 1:3){
      rp <- ISOResponsibleParty$new()
      rp$setIndividualName(paste0("someone",i))
      rp$setOrganisationName("somewhere")
      rp$setPositionName(paste0("someposition",i))
      rp$setRole("pointOfContact")
      contact <- ISOContact$new()
      phone <- ISOTelephone$new()
      phone$setVoice(paste0("myphonenumber",i))
      phone$setFacsimile(paste0("myfacsimile",i))
      contact$setPhone(phone)
      address <- ISOAddress$new()
      address$setDeliveryPoint("theaddress")
      address$setCity("thecity")
      address$setPostalCode("111")
      address$setCountry("France")
      address$setEmail("someone@theorg.org")
      contact$setAddress(address)
      res <- ISOOnlineResource$new()
      res$setLinkage("http://somelink")
      res$setName("someresourcename")
      contact$setOnlineResource(res)
      rp$setContactInfo(contact)
      md$addContact(rp)
   }
   
   #VectorSpatialRepresentation
   vsr <- ISOVectorSpatialRepresentation$new()
   vsr$setTopologyLevel("geometryOnly")
   geomObject <- ISOGeometricObjects$new()
   geomObject$setGeometricObjectType("surface")
   geomObject$setGeometricObjectCount(5L)
   vsr$addGeometricObjects(geomObject)
   md$addSpatialRepresentationInfo(vsr)
   
   #ReferenceSystem
   rs <- ISOReferenceSystem$new()
   rsId <- ISOReferenceIdentifier$new(code = "4326", codeSpace = "EPSG")
   rs$setReferenceSystemIdentifier(rsId)
   md$addReferenceSystemInfo(rs)
   
   #data identification
   ident <- ISODataIdentification$new()
   ident$setAbstract("abstract")
   ident$setPurpose("purpose")
   ident$addCredit("credit1")
   ident$addCredit("credit2")
   ident$addCredit("credit3")
   ident$addStatus("completed")
   ident$addLanguage("eng")
   ident$addCharacterSet("utf8")
   ident$addTopicCategory("biota")
   ident$addTopicCategory("oceans")
   
   #adding a point of contact
   rp <- ISOResponsibleParty$new()
   rp$setIndividualName("someone")
   rp$setOrganisationName("somewhere")
   rp$setPositionName("someposition")
   rp$setRole("pointOfContact")
   contact <- ISOContact$new()
   phone <- ISOTelephone$new()
   phone$setVoice("myphonenumber")
   phone$setFacsimile("myfacsimile")
   contact$setPhone(phone)
   address <- ISOAddress$new()
   address$setDeliveryPoint("theaddress")
   address$setCity("thecity")
   address$setPostalCode("111")
   address$setCountry("France")
   address$setEmail("someone@theorg.org")
   contact$setAddress(address)
   res <- ISOOnlineResource$new()
   res$setLinkage("http://somelink")
   res$setName("somename")
   contact$setOnlineResource(res)
   rp$setContactInfo(contact)
   ident$addPointOfContact(rp)
   
   #citation
   ct <- ISOCitation$new()
   ct$setTitle("sometitle")
   d <- ISODate$new()
   d$setDate(ISOdate(2015, 1, 1, 1))
   d$setDateType("publication")
   ct$addDate(d)
   ct$setEdition("1.0")
   ct$setEditionDate(as.Date(ISOdate(2015, 1, 1, 1)))
   ct$addIdentifier(ISOMetaIdentifier$new(code = "identifier"))
   ct$addPresentationForm("mapDigital")
   ct$addCitedResponsibleParty(rp)
   ident$setCitation(ct)
   
   #graphic overview
   go1 <- ISOBrowseGraphic$new(
     fileName = "http://wwww.somefile.org/png1",
     fileDescription = "Map Overview 1",
     fileType = "image/png"
   )
   go2 <- ISOBrowseGraphic$new(
     fileName = "http://www.somefile.org/png2",
     fileDescription = "Map Overview 2",
     fileType = "image/png"
   )
   ident$addGraphicOverview(go1)
   ident$addGraphicOverview(go2)
   
   #maintenance information
   mi <- ISOMaintenanceInformation$new()
   mi$setMaintenanceFrequency("daily")
   ident$addResourceMaintenance(mi)
   
   #adding legal constraints
   lc <- ISOLegalConstraints$new()
   lc$addUseLimitation("limitation1")
   lc$addUseLimitation("limitation2")
   lc$addUseLimitation("limitation3")
   lc$addAccessConstraint("copyright")
   lc$addAccessConstraint("license")
   lc$addUseConstraint("copyright")
   lc$addUseConstraint("license")
   ident$addResourceConstraints(lc)
   
   #adding security constraints
   sc <- ISOSecurityConstraints$new()
   sc$setClassification("secret")
   sc$setUserNote("ultra secret")
   sc$setClassificationSystem("no classification in particular")
   sc$setHandlingDescription("description")
   ident$addResourceConstraints(sc)
   
   #adding extent
   extent <- ISOExtent$new()
   bbox <- ISOGeographicBoundingBox$new(minx = -180, miny = -90, maxx = 180, maxy = 90)
   extent$addGeographicElement(bbox)
   ident$addExtent(extent)
   
   #add keywords
   kwds <- ISOKeywords$new()
   kwds$addKeyword("keyword1")
   kwds$addKeyword("keyword2")
   kwds$setKeywordType("theme")
   th <- ISOCitation$new()
   th$setTitle("General")
   th$addDate(d)
   kwds$setThesaurusName(th)
   ident$addKeywords(kwds)
   
   #add an INSPIRE spatial data theme?
   inspire_kwd <- ISOKeywords$new()
   anc1 <- ISOAnchor$new(
     name = "Environmental monitoring facilities",
     href = "http://inspire.ec.europa.eu/theme/ef"
   )
   inspire_kwd$addKeyword(anc1)
   inspire_kwd$setKeywordType("theme")
   th <- ISOCitation$new()
   th$setTitle(
     ISOAnchor$new(
       name = "GEMET - INSPIRE themes, version 1.0",
       href="http://www.eionet.europa.eu/gemet/inspire_themes"
     )
   )
   inspire_date <- ISODate$new()
   inspire_date$setDate(as.Date("2008-06-01"))
   inspire_date$setDateType("publication")
   th$addDate(inspire_date)
   inspire_kwd$setThesaurusName(th)
   ident$addKeywords(inspire_kwd)
   
   #supplementalInformation
   ident$setSupplementalInformation("some additional information")
   
   #spatial representation type
   ident$addSpatialRepresentationType("vector")
   
   md$addIdentificationInfo(ident)
   
   #Distribution
   distrib <- ISODistribution$new()
   dto <- ISODigitalTransferOptions$new()  
   for(i in 1:3){
     or <- ISOOnlineResource$new()
     or$setLinkage(paste0("http://somelink",i))
     or$setName(paste0("name",i))
     or$setDescription(paste0("description",i))
     or$setProtocol("WWW:LINK-1.0-http--link")
     dto$addOnlineResource(or)
   }
   distrib$setDigitalTransferOptions(dto)
   md$setDistributionInfo(distrib)
   
   #create dataQuality object with a 'dataset' scope
   dq <- ISODataQuality$new()
   scope <- ISODataQualityScope$new()
   scope$setLevel("dataset")
   dq$setScope(scope)
  
   #add data quality reports...
  
   #add a report the data quality
   dc <- ISODomainConsistency$new()
   result <- ISOConformanceResult$new()
   spec <- ISOCitation$new()
   spec$setTitle("Data Quality check")
   spec$addAlternateTitle("This is is some data quality check report")
   d <- ISODate$new()
   d$setDate(ISOdate(2015, 1, 1, 1))
   d$setDateType("publication")
   spec$addDate(d)
   result$setSpecification(spec)
   result$setExplanation("some explanation about the conformance")
   result$setPass(TRUE)
   dc$addResult(result)
   dq$addReport(dc)
  
   #add INSPIRE reports?
   #INSPIRE - interoperability of spatial data sets and services
   dc_inspire1 <- ISODomainConsistency$new()
   cr_inspire1 <- ISOConformanceResult$new()
   cr_inspire_spec1 <- ISOCitation$new()
   cr_title1 <- paste(
     "Commission Regulation (EU) No 1089/2010 of 23 November 2010 implementing Directive 2007/2/EC",
     "of the European Parliament and of the Council as regards interoperability of spatial data",
     "sets and services"
   )
   cr_inspire_spec1$setTitle(cr_title1)
   cr_inspire1$setExplanation("See the referenced specification")
   cr_inspire_date1 <- ISODate$new()
   cr_inspire_date1$setDate(ISOdate(2010,12,8))
   cr_inspire_date1$setDateType("publication")
   cr_inspire_spec1$addDate(cr_inspire_date1)
   cr_inspire1$setSpecification(cr_inspire_spec1)
   cr_inspire1$setPass(TRUE)
   dc_inspire1$addResult(cr_inspire1)
   dq$addReport(dc_inspire1)
   #INSPIRE - metadata
   dc_inspire2 <- ISODomainConsistency$new()
   cr_inspire2 <- ISOConformanceResult$new()
   cr_inspire_spec2 <- ISOCitation$new()
   cr_title2 <- paste(
     "COMMISSION REGULATION (EC) No 1205/2008 of 3 December 2008 implementing Directive 2007/2/EC",
     "of the European Parliament and of the Council as regards metadata"
   )
   cr_inspire_spec2$setTitle(cr_title2)
   cr_inspire2$setExplanation("See the referenced specification")
   cr_inspire_date2 <- ISODate$new()
   cr_inspire_date2$setDate(ISOdate(2008,12,4))
   cr_inspire_date2$setDateType("publication")
   cr_inspire_spec2$addDate(cr_inspire_date2)
   cr_inspire2$setSpecification(cr_inspire_spec2)
   cr_inspire2$setPass(TRUE)
   dc_inspire2$addResult(cr_inspire2)
   dq$addReport(dc_inspire2)
   
   #add lineage
   lineage <- ISOLineage$new()
   lineage$setStatement("statement")
   dq$setLineage(lineage)
   
   md$addDataQualityInfo(dq)
   
   #Content Information
   #-------------------------
   #add a feature catalogue description
   fcd <- ISOFeatureCatalogueDescription$new()
   fcd$setComplianceCode(FALSE)
   fcd$addLanguage("eng")
   fcd$setIncludedWithDataset(FALSE)
   cit = ISOCitation$new()
   cit$setTitle("sometitle")
   d <- ISODate$new()
   d$setDate(ISOdate(2015, 1, 1, 1))
   d$setDateType("publication")
   cit$addDate(d)
   cit$setEdition("1.0")
   cit$setEditionDate(as.Date(ISOdate(2015, 1, 1, 1)))
   contact = ISOContact$new()
   fcLink <- ISOOnlineResource$new()
   fcLink$setLinkage("http://somelink/featurecatalogue")
   contact$setOnlineResource(fcLink)
   rp = ISOResponsibleParty$new()
   rp$setRole("publisher")
   rp$setContactInfo(contact)
   cit$addCitedResponsibleParty(rp)
   fcd$addFeatureCatalogueCitation(cit)
   md$addContentInfo(fcd)
   
   #XML representation of the ISOMetadata
   xml <- md$encode()
   
   #example 2 - READ: Create an ISO metadata reading from XML
   ######################################################
   \donttest{
   require(XML)
   xmlfile <- system.file("extdata/examples", "metadata.xml", package = "geometa")
   xml <- xmlParse(xmlfile)
   md <- ISOMetadata$new(xml = xml)
   }

}
\references{
- ISO 19139 \url{https://schemas.isotc211.org/19139/-/gmd/1.0/gmd/#element_MD_Metadata}
  
  - ISO 19115-3 \url{https://schemas.isotc211.org/19115/-3/mdb/2.0/mdb/#element_MD_Metadata}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{element}
\keyword{metadata}
\section{Super classes}{
\code{\link[geometa:geometaLogger]{geometa::geometaLogger}} -> \code{\link[geometa:ISOAbstractObject]{geometa::ISOAbstractObject}} -> \code{ISOMetadata}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{fileIdentifier}}{fileIdentifier [0..1] : character (ISO 19139)}

\item{\code{metadataIdentifier}}{metadataIdentifier [0..1] : ISOMetaIdentifier (ISO 19115-3)}

\item{\code{language}}{language [0..1] : character (ISO 19139)}

\item{\code{defaultLocale}}{[0..1] : ISOLocale (ISO 19115-3)}

\item{\code{characterSet}}{characterSet [0..1] : ISOCharacterSet = "utf8"}

\item{\code{parentIdentifier}}{parentIdentifier [0..1] : character}

\item{\code{parentMetadata}}{parentMetadata [0..1]: ISOCitation (ISO 19115-3)}

\item{\code{hierarchyLevel}}{hierarchyLevel [0..*] : ISOScopeCode = "dataset"}

\item{\code{hierarchyLevelName}}{hierarchyLevelName [0..*] : character}

\item{\code{metadataScope}}{metadataScope [0..*] : ISOMetadataScope (ISO 19115-3)}

\item{\code{contact}}{contact [1..*] : ISOResponsibleParty}

\item{\code{dateStamp}}{dateStamp : POSIXct/POSIXt}

\item{\code{dateInfo}}{dateInfo [1..*] : ISODate}

\item{\code{metadataStandardName}}{metadataStandardName [0..1] : character (ISO 19139)}

\item{\code{metadataStandardVersion}}{metadataStandardVersion [0..1] : character (ISO 19139)}

\item{\code{metadataStandard}}{metadataStandard [0..*] : ISOCitation (ISO 19115-3)}

\item{\code{metadataProfile}}{metadataProfile [0..*] : ISOCitation (ISO 19115-3)}

\item{\code{alternativeMetadataReference}}{alternativeMetadataReference [0..*] : ISOCitation (ISO 19115-3)}

\item{\code{otherLocale}}{otherLocale [0..*]  : ISOLocale (ISO 19115-3)}

\item{\code{dataSetURI}}{dataSetURI [0..1] : character (ISO 19139)}

\item{\code{metadataLinkage}}{metadataLinkage [0..*] : ISOOnlineResource (ISO 19115-3)}

\item{\code{locale}}{locale [0..*]: ISOLocale (ISO 19139)}

\item{\code{spatialRepresentationInfo}}{spatialRepresentationInfo [0..*]: ISOSpatialRepresentation}

\item{\code{referenceSystemInfo}}{referenceSystemInfo [0..*]: ISOReferenceSystem}

\item{\code{metadataExtensionInfo}}{metadataExtensionInfo [0..*]: ISOMetadataExtensionInformation}

\item{\code{identificationInfo}}{identificationInfo [1..*]: ISOIdentification}

\item{\code{contentInfo}}{contentInfo [0..*]}

\item{\code{distributionInfo}}{distributionInfo [0..1] : ISODistribution}

\item{\code{dataQualityInfo}}{dataQualityInfo [0..*]: ISODataQuality}

\item{\code{resourceLineage}}{resourceLineage [0..*]: ISOLineage (ISO 19115-3)}

\item{\code{metadataMaintenance}}{metadataMaintenance [0..1]: ISOMaintenanceInformation}

\item{\code{portrayalCatalogueInfo}}{portrayalCatalogueInfo [0..*]}

\item{\code{applicationSchemaInformation}}{applicationSchemaInfo [0..*]}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ISOMetadata-new}{\code{ISOMetadata$new()}}
\item \href{#method-ISOMetadata-setFileIdentifier}{\code{ISOMetadata$setFileIdentifier()}}
\item \href{#method-ISOMetadata-setMetadataIdentifier}{\code{ISOMetadata$setMetadataIdentifier()}}
\item \href{#method-ISOMetadata-setLanguage}{\code{ISOMetadata$setLanguage()}}
\item \href{#method-ISOMetadata-setDefaultLocale}{\code{ISOMetadata$setDefaultLocale()}}
\item \href{#method-ISOMetadata-setCharacterSet}{\code{ISOMetadata$setCharacterSet()}}
\item \href{#method-ISOMetadata-setParentIdentifier}{\code{ISOMetadata$setParentIdentifier()}}
\item \href{#method-ISOMetadata-setParentMetadata}{\code{ISOMetadata$setParentMetadata()}}
\item \href{#method-ISOMetadata-addHierarchyLevel}{\code{ISOMetadata$addHierarchyLevel()}}
\item \href{#method-ISOMetadata-delHierarchyLevel}{\code{ISOMetadata$delHierarchyLevel()}}
\item \href{#method-ISOMetadata-addHierarchyLevelName}{\code{ISOMetadata$addHierarchyLevelName()}}
\item \href{#method-ISOMetadata-delHierarchyLevelName}{\code{ISOMetadata$delHierarchyLevelName()}}
\item \href{#method-ISOMetadata-addMetadataScope}{\code{ISOMetadata$addMetadataScope()}}
\item \href{#method-ISOMetadata-delMetadataScope}{\code{ISOMetadata$delMetadataScope()}}
\item \href{#method-ISOMetadata-addContact}{\code{ISOMetadata$addContact()}}
\item \href{#method-ISOMetadata-delContact}{\code{ISOMetadata$delContact()}}
\item \href{#method-ISOMetadata-setDateStamp}{\code{ISOMetadata$setDateStamp()}}
\item \href{#method-ISOMetadata-addDate}{\code{ISOMetadata$addDate()}}
\item \href{#method-ISOMetadata-delDate}{\code{ISOMetadata$delDate()}}
\item \href{#method-ISOMetadata-setMetadataStandardName}{\code{ISOMetadata$setMetadataStandardName()}}
\item \href{#method-ISOMetadata-setMetadataStandardVersion}{\code{ISOMetadata$setMetadataStandardVersion()}}
\item \href{#method-ISOMetadata-addMetadataStandard}{\code{ISOMetadata$addMetadataStandard()}}
\item \href{#method-ISOMetadata-delMetadataStandard}{\code{ISOMetadata$delMetadataStandard()}}
\item \href{#method-ISOMetadata-addMetadataProfile}{\code{ISOMetadata$addMetadataProfile()}}
\item \href{#method-ISOMetadata-delMetadataProfile}{\code{ISOMetadata$delMetadataProfile()}}
\item \href{#method-ISOMetadata-addAlternativeMetadataReference}{\code{ISOMetadata$addAlternativeMetadataReference()}}
\item \href{#method-ISOMetadata-delAlternativeMetadataReference}{\code{ISOMetadata$delAlternativeMetadataReference()}}
\item \href{#method-ISOMetadata-setDataSetURI}{\code{ISOMetadata$setDataSetURI()}}
\item \href{#method-ISOMetadata-addMetadataLinkage}{\code{ISOMetadata$addMetadataLinkage()}}
\item \href{#method-ISOMetadata-delMetadataLinkage}{\code{ISOMetadata$delMetadataLinkage()}}
\item \href{#method-ISOMetadata-addLocale}{\code{ISOMetadata$addLocale()}}
\item \href{#method-ISOMetadata-delLocale}{\code{ISOMetadata$delLocale()}}
\item \href{#method-ISOMetadata-addSpatialRepresentationInfo}{\code{ISOMetadata$addSpatialRepresentationInfo()}}
\item \href{#method-ISOMetadata-setSpatialRepresentationInfo}{\code{ISOMetadata$setSpatialRepresentationInfo()}}
\item \href{#method-ISOMetadata-delSpatialRepresentationInfo}{\code{ISOMetadata$delSpatialRepresentationInfo()}}
\item \href{#method-ISOMetadata-addReferenceSystemInfo}{\code{ISOMetadata$addReferenceSystemInfo()}}
\item \href{#method-ISOMetadata-setReferenceSystemInfo}{\code{ISOMetadata$setReferenceSystemInfo()}}
\item \href{#method-ISOMetadata-delReferenceSystemInfo}{\code{ISOMetadata$delReferenceSystemInfo()}}
\item \href{#method-ISOMetadata-addMetadataExtensionInfo}{\code{ISOMetadata$addMetadataExtensionInfo()}}
\item \href{#method-ISOMetadata-delMetadataExtensionInfo}{\code{ISOMetadata$delMetadataExtensionInfo()}}
\item \href{#method-ISOMetadata-addIdentificationInfo}{\code{ISOMetadata$addIdentificationInfo()}}
\item \href{#method-ISOMetadata-setIdentificationInfo}{\code{ISOMetadata$setIdentificationInfo()}}
\item \href{#method-ISOMetadata-delIdentificationInfo}{\code{ISOMetadata$delIdentificationInfo()}}
\item \href{#method-ISOMetadata-setDistributionInfo}{\code{ISOMetadata$setDistributionInfo()}}
\item \href{#method-ISOMetadata-addDataQualityInfo}{\code{ISOMetadata$addDataQualityInfo()}}
\item \href{#method-ISOMetadata-setDataQualityInfo}{\code{ISOMetadata$setDataQualityInfo()}}
\item \href{#method-ISOMetadata-delDataQualityInfo}{\code{ISOMetadata$delDataQualityInfo()}}
\item \href{#method-ISOMetadata-addResourceLineage}{\code{ISOMetadata$addResourceLineage()}}
\item \href{#method-ISOMetadata-delResourceLineage}{\code{ISOMetadata$delResourceLineage()}}
\item \href{#method-ISOMetadata-setMetadataMaintenance}{\code{ISOMetadata$setMetadataMaintenance()}}
\item \href{#method-ISOMetadata-addContentInfo}{\code{ISOMetadata$addContentInfo()}}
\item \href{#method-ISOMetadata-delContentInfo}{\code{ISOMetadata$delContentInfo()}}
\item \href{#method-ISOMetadata-addPortrayalCatalogueInfo}{\code{ISOMetadata$addPortrayalCatalogueInfo()}}
\item \href{#method-ISOMetadata-delPortrayalCatalogueInfo}{\code{ISOMetadata$delPortrayalCatalogueInfo()}}
\item \href{#method-ISOMetadata-clone}{\code{ISOMetadata$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="ERROR"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-ERROR'><code>geometa::geometaLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="INFO"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-INFO'><code>geometa::geometaLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="WARN"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-WARN'><code>geometa::geometaLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addFieldAttrs"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addFieldAttrs'><code>geometa::ISOAbstractObject$addFieldAttrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addListElement'><code>geometa::ISOAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="checkMetadataStandardCompliance"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-checkMetadataStandardCompliance'><code>geometa::ISOAbstractObject$checkMetadataStandardCompliance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="contains"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-contains'><code>geometa::ISOAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="createLocalisedProperty"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-createLocalisedProperty'><code>geometa::ISOAbstractObject$createLocalisedProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="decode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-decode'><code>geometa::ISOAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="delListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-delListElement'><code>geometa::ISOAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="encode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-encode'><code>geometa::ISOAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClass"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClass'><code>geometa::ISOAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClassName"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClassName'><code>geometa::ISOAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getNamespaceDefinition"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getNamespaceDefinition'><code>geometa::ISOAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isDocument"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isDocument'><code>geometa::ISOAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isFieldInheritedFrom"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isFieldInheritedFrom'><code>geometa::ISOAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="print"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-print'><code>geometa::ISOAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="save"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-save'><code>geometa::ISOAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setAttr"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setAttr'><code>geometa::ISOAbstractObject$setAttr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeList"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeList'><code>geometa::ISOAbstractObject$setCodeList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeListValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeListValue'><code>geometa::ISOAbstractObject$setCodeListValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeSpace"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeSpace'><code>geometa::ISOAbstractObject$setCodeSpace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setHref"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setHref'><code>geometa::ISOAbstractObject$setHref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setId"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setId'><code>geometa::ISOAbstractObject$setId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setIsNull"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setIsNull'><code>geometa::ISOAbstractObject$setIsNull()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setValue'><code>geometa::ISOAbstractObject$setValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="stopIfMetadataStandardIsNot"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-stopIfMetadataStandardIsNot'><code>geometa::ISOAbstractObject$stopIfMetadataStandardIsNot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="validate"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-validate'><code>geometa::ISOAbstractObject$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="wrapBaseElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-wrapBaseElement'><code>geometa::ISOAbstractObject$wrapBaseElement()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-new"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-new}{}}}
\subsection{Method \code{new()}}{
Initializes object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[XML]{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-setFileIdentifier"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-setFileIdentifier}{}}}
\subsection{Method \code{setFileIdentifier()}}{
Set file identifier
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$setFileIdentifier(fileIdentifier)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fileIdentifier}}{file identifier}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-setMetadataIdentifier"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-setMetadataIdentifier}{}}}
\subsection{Method \code{setMetadataIdentifier()}}{
set metadata identifier
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$setMetadataIdentifier(metadataIdentifier)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metadataIdentifier}}{metadata identifier}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-setLanguage"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-setLanguage}{}}}
\subsection{Method \code{setLanguage()}}{
Set language
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$setLanguage(locale)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{locale}}{object of class \link{ISOLanguage} or any \link{character}
from values returned by \code{ISOLanguages$values()}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-setDefaultLocale"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-setDefaultLocale}{}}}
\subsection{Method \code{setDefaultLocale()}}{
Set default locale
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$setDefaultLocale(locale)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{locale}}{object of class \link{ISOLocale}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-setCharacterSet"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-setCharacterSet}{}}}
\subsection{Method \code{setCharacterSet()}}{
Set charset
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$setCharacterSet(charset)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{charset}}{object of class \link{ISOCharacterSet} or any \link{character}
from values returned by \code{ISOCharacterSet$values()}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-setParentIdentifier"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-setParentIdentifier}{}}}
\subsection{Method \code{setParentIdentifier()}}{
Set parent identifier
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$setParentIdentifier(parentIdentifier)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parentIdentifier}}{parent identifier}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-setParentMetadata"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-setParentMetadata}{}}}
\subsection{Method \code{setParentMetadata()}}{
Set parent metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$setParentMetadata(parentMetadata)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parentMetadata}}{parent metadata}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-addHierarchyLevel"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-addHierarchyLevel}{}}}
\subsection{Method \code{addHierarchyLevel()}}{
Adds hierarchy level
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$addHierarchyLevel(level)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{level}}{object of class \link{ISOScopeCode} or any \link{character}
from values returned by \code{ISOScopeCode$values()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-delHierarchyLevel"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-delHierarchyLevel}{}}}
\subsection{Method \code{delHierarchyLevel()}}{
Deletes hierarchy level
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$delHierarchyLevel(level)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{level}}{object of class \link{ISOScopeCode} or any \link{character}
from values returned by \code{ISOScopeCode$values()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-addHierarchyLevelName"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-addHierarchyLevelName}{}}}
\subsection{Method \code{addHierarchyLevelName()}}{
Adds hierarchy level name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$addHierarchyLevelName(levelName)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{levelName}}{object of class \link{character}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-delHierarchyLevelName"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-delHierarchyLevelName}{}}}
\subsection{Method \code{delHierarchyLevelName()}}{
Deletes hierarchy level name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$delHierarchyLevelName(levelName)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{levelName}}{object of class \link{character}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-addMetadataScope"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-addMetadataScope}{}}}
\subsection{Method \code{addMetadataScope()}}{
Adds metadata scope
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$addMetadataScope(metadataScope)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metadataScope}}{object of class \link{ISOMetadataScope} or any \link{character} among
values returned by \code{ISOScopeCode$values()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-delMetadataScope"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-delMetadataScope}{}}}
\subsection{Method \code{delMetadataScope()}}{
Deletes metadata scope
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$delMetadataScope(metadataScope)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metadataScope}}{object of class \link{ISOMetadataScope} or any \link{character} among
values returned by \code{ISOScopeCode$values()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-addContact"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-addContact}{}}}
\subsection{Method \code{addContact()}}{
Adds contact
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$addContact(contact)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{contact}}{object of class \link{ISOResponsibleParty} for ISO 19139 or
inheriting class \link{ISOAbstractResponsibility} for ISO 19115-3}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-delContact"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-delContact}{}}}
\subsection{Method \code{delContact()}}{
Deletes contact
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$delContact(contact)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{contact}}{object of class \link{ISOResponsibleParty} for ISO 19139 or
inheriting class \link{ISOAbstractResponsibility} for ISO 19115-3}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-setDateStamp"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-setDateStamp}{}}}
\subsection{Method \code{setDateStamp()}}{
Set date stamp
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$setDateStamp(date)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{date}}{date}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-addDate"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-addDate}{}}}
\subsection{Method \code{addDate()}}{
Adds date
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$addDate(date)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{date}}{object of class \link{ISODate}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-delDate"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-delDate}{}}}
\subsection{Method \code{delDate()}}{
Deletes date
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$delDate(date)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{date}}{object of class \link{ISODate}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-setMetadataStandardName"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-setMetadataStandardName}{}}}
\subsection{Method \code{setMetadataStandardName()}}{
Set metadata standard name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$setMetadataStandardName(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-setMetadataStandardVersion"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-setMetadataStandardVersion}{}}}
\subsection{Method \code{setMetadataStandardVersion()}}{
Set metadata standard version
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$setMetadataStandardVersion(version)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version}}{version}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-addMetadataStandard"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-addMetadataStandard}{}}}
\subsection{Method \code{addMetadataStandard()}}{
Adds metadata standard
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$addMetadataStandard(metadataStandard)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metadataStandard}}{object of class \link{ISOCitation} or \link{character}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-delMetadataStandard"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-delMetadataStandard}{}}}
\subsection{Method \code{delMetadataStandard()}}{
Deletes metadata standard
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$delMetadataStandard(metadataStandard)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metadataStandard}}{object of class \link{ISOCitation} or \link{character}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-addMetadataProfile"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-addMetadataProfile}{}}}
\subsection{Method \code{addMetadataProfile()}}{
Adds metadata profile
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$addMetadataProfile(metadataProfile)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metadataProfile}}{object of class \link{ISOCitation} or \link{character}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-delMetadataProfile"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-delMetadataProfile}{}}}
\subsection{Method \code{delMetadataProfile()}}{
Deletes metadata profile
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$delMetadataProfile(metadataProfile)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metadataProfile}}{object of class \link{ISOCitation} or \link{character}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-addAlternativeMetadataReference"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-addAlternativeMetadataReference}{}}}
\subsection{Method \code{addAlternativeMetadataReference()}}{
Adds alternative metadata reference
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$addAlternativeMetadataReference(alternativeMetadataReference)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alternativeMetadataReference}}{object of class \link{ISOCitation} or \link{character}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-delAlternativeMetadataReference"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-delAlternativeMetadataReference}{}}}
\subsection{Method \code{delAlternativeMetadataReference()}}{
Deletes alternative metadata reference
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$delAlternativeMetadataReference(alternativeMetadataReference)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alternativeMetadataReference}}{object of class \link{ISOCitation} or \link{character}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-setDataSetURI"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-setDataSetURI}{}}}
\subsection{Method \code{setDataSetURI()}}{
Set dataset URI
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$setDataSetURI(dataSetURI)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataSetURI}}{dataset URI}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-addMetadataLinkage"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-addMetadataLinkage}{}}}
\subsection{Method \code{addMetadataLinkage()}}{
Adds metadata linkage
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$addMetadataLinkage(metadataLinkage)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metadataLinkage}}{object of class \link{ISOOnlineResource}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-delMetadataLinkage"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-delMetadataLinkage}{}}}
\subsection{Method \code{delMetadataLinkage()}}{
Deletes metadata linkage
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$delMetadataLinkage(metadataLinkage)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metadataLinkage}}{object of class \link{ISOOnlineResource}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-addLocale"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-addLocale}{}}}
\subsection{Method \code{addLocale()}}{
Adds locale
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$addLocale(locale)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{locale}}{object of class \link{ISOLocale}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-delLocale"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-delLocale}{}}}
\subsection{Method \code{delLocale()}}{
Deletes locale
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$delLocale(locale)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{locale}}{object of class \link{ISOLocale}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-addSpatialRepresentationInfo"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-addSpatialRepresentationInfo}{}}}
\subsection{Method \code{addSpatialRepresentationInfo()}}{
Adds spatial representation info
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$addSpatialRepresentationInfo(spatialRepresentationInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{spatialRepresentationInfo}}{object of class \link{ISOSpatialRepresentation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-setSpatialRepresentationInfo"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-setSpatialRepresentationInfo}{}}}
\subsection{Method \code{setSpatialRepresentationInfo()}}{
Sets spatial representation info
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$setSpatialRepresentationInfo(spatialRepresentationInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{spatialRepresentationInfo}}{object of class \link{ISOSpatialRepresentation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-delSpatialRepresentationInfo"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-delSpatialRepresentationInfo}{}}}
\subsection{Method \code{delSpatialRepresentationInfo()}}{
Deletes spatial representation info
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$delSpatialRepresentationInfo(spatialRepresentationInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{spatialRepresentationInfo}}{object of class \link{ISOSpatialRepresentation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-addReferenceSystemInfo"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-addReferenceSystemInfo}{}}}
\subsection{Method \code{addReferenceSystemInfo()}}{
Adds reference system info
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$addReferenceSystemInfo(referenceSystemInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{referenceSystemInfo}}{object of class \link{ISOReferenceSystem}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-setReferenceSystemInfo"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-setReferenceSystemInfo}{}}}
\subsection{Method \code{setReferenceSystemInfo()}}{
Sets reference system info
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$setReferenceSystemInfo(referenceSystemInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{referenceSystemInfo}}{object of class \link{ISOReferenceSystem}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-delReferenceSystemInfo"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-delReferenceSystemInfo}{}}}
\subsection{Method \code{delReferenceSystemInfo()}}{
Deletes reference system info
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$delReferenceSystemInfo(referenceSystemInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{referenceSystemInfo}}{object of class \link{ISOReferenceSystem}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-addMetadataExtensionInfo"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-addMetadataExtensionInfo}{}}}
\subsection{Method \code{addMetadataExtensionInfo()}}{
Adds metadata extension info
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$addMetadataExtensionInfo(metadataExtensionInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metadataExtensionInfo}}{object of class \link{ISOMetadataExtensionInformation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-delMetadataExtensionInfo"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-delMetadataExtensionInfo}{}}}
\subsection{Method \code{delMetadataExtensionInfo()}}{
Deletes metadata extension info
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$delMetadataExtensionInfo(metadataExtensionInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metadataExtensionInfo}}{object of class \link{ISOMetadataExtensionInformation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-addIdentificationInfo"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-addIdentificationInfo}{}}}
\subsection{Method \code{addIdentificationInfo()}}{
Adds metadata extension info
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$addIdentificationInfo(identificationInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identificationInfo}}{object of class inheriting \link{ISOIdentification}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-setIdentificationInfo"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-setIdentificationInfo}{}}}
\subsection{Method \code{setIdentificationInfo()}}{
Sets metadata extension info
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$setIdentificationInfo(identificationInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identificationInfo}}{object of class inheriting \link{ISOIdentification}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-delIdentificationInfo"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-delIdentificationInfo}{}}}
\subsection{Method \code{delIdentificationInfo()}}{
Deletes metadata extension info
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$delIdentificationInfo(identificationInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identificationInfo}}{object of class inheriting \link{ISOIdentification}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-setDistributionInfo"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-setDistributionInfo}{}}}
\subsection{Method \code{setDistributionInfo()}}{
Sets metadata extension info
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$setDistributionInfo(distributionInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{distributionInfo}}{object of class \link{ISODistribution}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if set, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-addDataQualityInfo"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-addDataQualityInfo}{}}}
\subsection{Method \code{addDataQualityInfo()}}{
Adds data quality info
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$addDataQualityInfo(dataQualityInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataQualityInfo}}{object of class \link{ISODataQuality}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-setDataQualityInfo"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-setDataQualityInfo}{}}}
\subsection{Method \code{setDataQualityInfo()}}{
Sets data quality info
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$setDataQualityInfo(dataQualityInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataQualityInfo}}{object of class \link{ISODataQuality}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-delDataQualityInfo"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-delDataQualityInfo}{}}}
\subsection{Method \code{delDataQualityInfo()}}{
Deletes data quality info
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$delDataQualityInfo(dataQualityInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataQualityInfo}}{object of class \link{ISODataQuality}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-addResourceLineage"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-addResourceLineage}{}}}
\subsection{Method \code{addResourceLineage()}}{
Adds lineage info
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$addResourceLineage(lineageInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lineageInfo}}{object of class \link{ISOLineage}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-delResourceLineage"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-delResourceLineage}{}}}
\subsection{Method \code{delResourceLineage()}}{
Deletes lineage info
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$delResourceLineage(lineageInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lineageInfo}}{object of class \link{ISOLineage}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-setMetadataMaintenance"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-setMetadataMaintenance}{}}}
\subsection{Method \code{setMetadataMaintenance()}}{
Sets metadata maintenance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$setMetadataMaintenance(metadataMaintenance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metadataMaintenance}}{object of class \link{ISOMaintenanceInformation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-addContentInfo"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-addContentInfo}{}}}
\subsection{Method \code{addContentInfo()}}{
Adds content information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$addContentInfo(contentInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{contentInfo}}{object of class inheriting \link{ISOAbstractContentInformation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-delContentInfo"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-delContentInfo}{}}}
\subsection{Method \code{delContentInfo()}}{
Deletes content information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$delContentInfo(contentInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{contentInfo}}{object of class inheriting \link{ISOAbstractContentInformation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-addPortrayalCatalogueInfo"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-addPortrayalCatalogueInfo}{}}}
\subsection{Method \code{addPortrayalCatalogueInfo()}}{
Adds portrayal catalogue info
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$addPortrayalCatalogueInfo(portrayalCatalogueInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{portrayalCatalogueInfo}}{object of class inheriting \link{ISOPortrayalCatalogueReference}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-delPortrayalCatalogueInfo"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-delPortrayalCatalogueInfo}{}}}
\subsection{Method \code{delPortrayalCatalogueInfo()}}{
Deletes portrayal catalogue info
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$delPortrayalCatalogueInfo(portrayalCatalogueInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{portrayalCatalogueInfo}}{object of class inheriting \link{ISOPortrayalCatalogueReference}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOMetadata-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ISOMetadata-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOMetadata$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
