% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pixel_count_ppp.R
\name{pixel_count_ppp}
\alias{pixel_count_ppp}
\title{Get number of events in a pixel}
\usage{
pixel_count_ppp(
  data,
  resolution = NULL,
  ndim = NULL,
  W = NULL,
  weights = NULL,
  DivideByPixelArea = FALSE,
  ...
)
}
\arguments{
\item{data}{the name of a hyperframe and column of interest.}

\item{resolution}{resolution of raster (distance map) (in km)}

\item{ndim}{the number of dimensions of grid cells (ndim^2). Users need to set either resolution or ndim.}

\item{W}{Optional window mask (object of class `"owin"`) determining the pixel raster.
`data` should be in the form of `"hyperframe$column"`.}

\item{weights}{Optional vector of weights associated with the points.}

\item{DivideByPixelArea}{Logical value determining whether the resulting pixel values should be devided by the pixel area. Default value is `False`.}

\item{...}{parameters passed on to the function.}
}
\value{
im objects
}
\description{
`pixel_count_ppp()` takes a column of hyperframes (ppp objects) and gets the number of events in each pixel.
}
\examples{
# Time variable
dat_out <- insurgencies[1:100, ]
dat_out$time <- as.numeric(dat_out$date - min(dat_out$date) + 1)

# Hyperframe
dat_hfr <- get_hfr(data = dat_out,
                   col = "type",
                   window = iraq_window,
                   time_col = "time",
                   time_range = c(1, max(dat_out$time)),
                   coordinates = c("longitude", "latitude"),
                   combine = TRUE)

# Get the number of events for each pixel
pixel_count_ppp(data = dat_hfr$all_combined)
}
