% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoarrowDummyWidget.R
\name{geoarrowDummyWidget}
\alias{geoarrowDummyWidget}
\title{Basic Widget to Showcase Things.}
\usage{
geoarrowDummyWidget(
  message,
  file,
  url,
  dataname = "mygeoarrowdata",
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{message}{Some text to be displayed on the generated web page.}

\item{file}{A local file path to a geoarrow file to be attached to the widget.}

\item{url}{A URL to a geoarrow file to be attached to the widget. Ignored if
\code{file} is supplied.}

\item{dataname}{The \code{'ATTACHINDEX'} to be used for the data attachment. See
\code{\link[htmltools]{htmlDependency}} for details, especially the \code{Details}
section on \code{attachment}.}

\item{width}{Fixed width for widget (in css units).
See \code{\link[htmlwidgets]{createWidget}} for details.}

\item{height}{Fixed height for widget (in css units).
See \code{\link[htmlwidgets]{createWidget}} for details.}

\item{elementId}{Use an explicit element ID for the widget.
See \code{\link[htmlwidgets]{createWidget}} for details.}
}
\value{
An \code{htmlwidget} with the parsed geoarrow data printed to the browser console.
}
\description{
Widget used to highlight efficiency of geoarrow data transfer. Doesn't do anything
useful, other than attaching data to a generated \code{htmlwidget} and printing that
in the browser console.
}
\examples{
url = "https://geoarrow-test.s3.eu-central-1.amazonaws.com/test_layer_interleaved.arrow"
wgt = geoarrowDummyWidget(url = url)
options(viewer = NULL)
wgt

}
