% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_SNP.R
\name{plot_SNP}
\alias{plot_SNP}
\title{Plot SNP Distribution on Chromosome Map}
\usage{
plot_SNP(
  chromosome_details,
  data,
  chromosome_color = "steelblue",
  title = "Chromosome map with SNPs",
  label_color = "black",
  image_width = 10,
  image_height = 10
)
}
\arguments{
\item{chromosome_details}{A data frame containing chromosome details with columns \code{Chr}, \code{start} and \code{stop}}

\item{data}{A data frame containing SNP data with columns \code{Chr}, \code{Pos}, and \code{SNP}.}

\item{chromosome_color}{Color of the chromosome bars (default: "skyblue").}

\item{title}{Title of the chromosome plot depicting the identified SNPs}

\item{label_color}{Color of the SNP labels (default: "black").}

\item{image_width}{width of the chromosome plot}

\item{image_height}{height of the chromosome plot}
}
\value{
A \code{ggplot} object for the SNP distribution plot.
}
\description{
Plots SNP positions across chromosomes with centromere markers using given chromosome details and SNP data.
}
\examples{
\donttest{
chromosome_details <- read.csv(system.file("extdata", "chromosome_details.csv", package = "geneNR"))
data <- read.csv(system.file("extdata", "identified_SNP.csv", package = "geneNR"))
chromosome_plot <- plot_SNP(chromosome_details = chromosome_details, data = data,
chromosome_color = "steelblue" ,title = "Chromosome map with SNPs", label_color = "black",
image_width = 15, image_height = 10)
print(chromosome_plot)
}
}
