% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier_fn.R
\name{performance.metrics}
\alias{performance.metrics}
\title{Performance of model predictions}
\usage{
performance.metrics(actual, predicted, metric)
}
\arguments{
\item{actual}{dataframe. Same formatting as \code{y}, containg some sort of classification data.}

\item{predicted}{dataframe. Same formatting as \code{x}, containg the predicted classifications of a model trained over the data in \code{x}.}

\item{metric}{character. String specifying the metric used, one of \code{accuracy}, \code{F1} and \code{TSS}.}
}
\value{
numeric.
}
\description{
Calculate the performance of a model through a comparison 
between predicted and observed labels. Available metrics are \code{accuracy},
\code{F1} and \code{TSS}.
}
\details{
\strong{The F-score or F-measure (F1)} is: \cr
\cr
\eqn{F1 = 2 \dfrac{Precision * Recall}{Precision + Recall}}, with \cr
\cr
\eqn{Precision = \dfrac{True Positive}{True Positive + False Positive}} \cr
\cr
\eqn{Recall = \dfrac{True Positive}{True Positive + False Negative}} \cr
\cr
\strong{Accuracy} is: \cr
\cr
\eqn{\dfrac{100 * (True Postives + True Negatives)}{True Postives + True Negatives + False Positives + False Negatives}}
\cr
 \cr
\strong{The Pierce's skill score (PSS),  Bookmaker's Informedness (BM) or True Skill Statistic (TSS)} is: \cr
\cr
\eqn{TSS = TPR + TNR - 1}, \cr
with \eqn{TPR} being the True Positive Rate, positives correctly labelled 
as such and \eqn{TNR}, the True Negative Rate, the rate of negatives correctly
labelled, such that:\cr
\cr
\eqn{TPR = \dfrac{True Positives}{True Positives + False Negatives}}
\cr
\eqn{TNR = \dfrac{True Negatives}{True Negatives + False Positives}}
\cr
Take in consideration the fact that the F1 score is not a robust metric in datasets with class imbalances.
}
\examples{
observed = c("FALSE", "TRUE", "FALSE", "TRUE", "TRUE")
predicted = c("TRUE", "TRUE", "TRUE", "TRUE", "TRUE")
performance.metrics(observed, predicted, "TSS")
}
\references{
PSS:
Peirce, C. S. (1884). The numerical measure of the success of predictions. Science, 4, 453–454.
}
