% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_eic.R
\name{batch_eic}
\alias{batch_eic}
\title{Finds batch of EICs}
\usage{
batch_eic(data, MOIs, tolerance = 5e-04)
}
\arguments{
\item{data}{a \emph{list} object. Data extracted from a cdf file,
ideally the output from extract_data().}

\item{MOIs}{a \emph{vector} object. A vector containing a list of all masses
of interest to be investigated.}

\item{tolerance}{a \emph{double} object. The tolerance allowed for the MOI.
Default is 0.0005.}
}
\value{
eic_list, \emph{list} object, containing \emph{data.frame} objects.
Data frames of time values, mass values, intensity values, and mass defects
for each MOI listed in the input csv or txt file.
}
\description{
\code{batch_eic} calculates the mass defect for each ion, then finds
each listed EICs of interest.
}
\details{
Extracted Ion Chromatogram (EIC) is a plot of intensity at a chosen
m/z value, or range of values, as a function of retention time.
This function uses find_eic() to find intensity values at the given
mass-to-charge (m/z) values, MOIs, and in a range around MOI given a
tolerance. Calculates the mass defect for each ion, then finds the specific
EICs of interest. Returns a data frame of time values, mass values, intensity
values,and mass defects.
}
\examples{
file1 <- system.file("extdata","sample1.cdf",package="gcxgclab")
frame <- extract_data(file1,mod_t=.5)
mois <- c(92.1397, 93.07058)
eics <- batch_eic(frame, MOIs=mois ,tolerance = 0.005)
for (i in 1:length(eics)){
   print(plot_eic(eics[[i]], title=paste("EIC for MOI",mois[i])))
   print(plot_eic(eics[[i]], title=paste("EIC for MOI",mois[i]), dim=2))
}

}
